/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BoundedExecutor
implements Executor {
    private static final Logger log = Logger.get(BoundedExecutor.class);
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final Runnable triggerTask = new Runnable(){

        @Override
        public void run() {
            BoundedExecutor.this.executeOrMerge();
        }
    };
    private final Executor coreExecutor;
    private final int maxThreads;

    public BoundedExecutor(Executor coreExecutor, int maxThreads) {
        Preconditions.checkNotNull((Object)coreExecutor, (Object)"coreExecutor is null");
        Preconditions.checkArgument((maxThreads > 0 ? 1 : 0) != 0, (Object)"maxThreads must be greater than zero");
        this.coreExecutor = coreExecutor;
        this.maxThreads = maxThreads;
    }

    @Override
    public void execute(Runnable task) {
        this.queue.add(task);
        this.coreExecutor.execute(this.triggerTask);
    }

    private void executeOrMerge() {
        int size = this.queueSize.incrementAndGet();
        if (size <= this.maxThreads) {
            do {
                try {
                    this.queue.poll().run();
                }
                catch (Throwable e) {
                    log.error(e, "Task failed");
                }
            } while (this.queueSize.getAndDecrement() > this.maxThreads);
        }
    }
}

