/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorFactoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class JdbcPlugin
implements Plugin {
    private final String name;
    private final Module module;
    private Map<String, String> optionalConfig = ImmutableMap.of();

    public JdbcPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf(Objects.requireNonNull(optionalConfig, "optionalConfig is null"));
    }

    public Iterable<ConnectorFactory> getConnectorFactories(ConnectorFactoryContext context) {
        return ImmutableList.of((Object)new JdbcConnectorFactory(this.name, this.module, this.optionalConfig, JdbcPlugin.getClassLoader()));
    }

    private static ClassLoader getClassLoader() {
        return (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)JdbcPlugin.class.getClassLoader());
    }
}

