/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.MetaBean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class MetaBeanBuilder {
    private static final Logger log = Logger.getLogger(MetaBeanBuilder.class.getName());
    private MetaBeanFactory[] factories;

    public MetaBeanBuilder() {
        this(new MetaBeanFactory[]{new IntrospectorMetaBeanFactory()});
    }

    public MetaBeanBuilder(MetaBeanFactory[] factories) {
        this.setFactories(factories);
    }

    public MetaBeanFactory[] getFactories() {
        return (MetaBeanFactory[])ArrayUtils.clone((Object[])this.factories);
    }

    public void setFactories(MetaBeanFactory[] factories) {
        this.factories = (MetaBeanFactory[])ArrayUtils.clone((Object[])factories);
    }

    public MetaBean buildForId(String beanInfoId) throws Exception {
        throw new IllegalArgumentException("MetaBean " + beanInfoId + " not found");
    }

    public Map<String, MetaBean> buildAll() throws Exception {
        return new HashMap<String, MetaBean>();
    }

    protected Class<?> findLocalClass(String className) {
        if (className != null) {
            try {
                return ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, String.format("Class not found: %s", className), e);
            }
        }
        return null;
    }

    public MetaBean buildForClass(Class<?> clazz) throws Exception {
        MetaBean meta = new MetaBean();
        if (clazz != null) {
            meta.setBeanClass(clazz);
            meta.setId(clazz.getName());
        }
        for (MetaBeanFactory factory : this.factories) {
            factory.buildMetaBean(meta);
        }
        return meta;
    }
}

