/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import org.apache.bval.model.DynaType;
import org.apache.commons.lang3.ArrayUtils;

public class DynaTypeEnum
implements DynaType {
    private final Class<?> enumClass;
    private Value[] enumConstants;

    public DynaTypeEnum(Class<?> enumClass) {
        this.enumClass = enumClass;
    }

    public DynaTypeEnum(Class<?> enumClass, String ... names) {
        this(enumClass);
        this.setEnumNames(names);
    }

    public void setEnumNames(String[] names) {
        this.enumConstants = new Value[names.length];
        int i = 0;
        for (String each : names) {
            this.enumConstants[i++] = new Value(each);
        }
    }

    public String getName() {
        return this.enumClass.getName();
    }

    @Override
    public Class<?> getRawType() {
        return this.enumClass;
    }

    public boolean isEnum() {
        return this.enumClass.isEnum();
    }

    public Value[] getEnumConstants() {
        return (Value[])ArrayUtils.clone((Object[])this.enumConstants);
    }

    public boolean isAssignableFrom(Class<?> cls) {
        return this.enumClass.isAssignableFrom(cls);
    }

    public static final class Value {
        final String name;

        Value(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }
}

