/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.QueryBuilder;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.plugin.jdbc.StandardReadMappings;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;

public class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    private static final Map<Type, String> SQL_TYPES = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)"boolean").put((Object)BigintType.BIGINT, (Object)"bigint").put((Object)IntegerType.INTEGER, (Object)"integer").put((Object)SmallintType.SMALLINT, (Object)"smallint").put((Object)TinyintType.TINYINT, (Object)"tinyint").put((Object)DoubleType.DOUBLE, (Object)"double precision").put((Object)RealType.REAL, (Object)"real").put((Object)VarbinaryType.VARBINARY, (Object)"varbinary").put((Object)DateType.DATE, (Object)"date").put((Object)TimeType.TIME, (Object)"time").put((Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)"time with timezone").put((Object)TimestampType.TIMESTAMP, (Object)"timestamp").put((Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)"timestamp with timezone").build();
    protected final String connectorId;
    protected final ConnectionFactory connectionFactory;
    protected final String identifierQuote;

    public BaseJdbcClient(JdbcConnectorId connectorId, BaseJdbcConfig config, String identifierQuote, ConnectionFactory connectionFactory) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        Objects.requireNonNull(config, "config is null");
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.connectionFactory.close();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<String> getSchemaNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<SchemaTableName> getTableNames(@Nullable String schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public JdbcTableHandle getTableHandle(SchemaTableName schemaTableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Optional<ReadMapping> toPrestoType(ConnectorSession session, JdbcTypeHandle typeHandle) {
        return StandardReadMappings.jdbcTypeToPrestoType(typeHandle);
    }

    @Override
    public ConnectorSplitSource getSplits(JdbcTableLayoutHandle layoutHandle) {
        JdbcTableHandle tableHandle = layoutHandle.getTable();
        JdbcSplit jdbcSplit = new JdbcSplit(this.connectorId, tableHandle.getCatalogName(), tableHandle.getSchemaName(), tableHandle.getTableName(), layoutHandle.getTupleDomain(), Optional.empty());
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)jdbcSplit));
    }

    @Override
    public Connection getConnection(JdbcSplit split) throws SQLException {
        Connection connection = this.connectionFactory.openConnection();
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public PreparedStatement buildSql(Connection connection, JdbcSplit split, List<JdbcColumnHandle> columnHandles) throws SQLException {
        return new QueryBuilder(this.identifierQuote).buildSql(this, connection, split.getCatalogName(), split.getSchemaName(), split.getTableName(), columnHandles, split.getTupleDomain(), split.getAdditionalPredicate());
    }

    @Override
    public void createTable(ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorTableMetadata tableMetadata) {
        return this.beginWriteTable(tableMetadata);
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorTableMetadata tableMetadata) {
        return this.beginWriteTable(tableMetadata);
    }

    private JdbcOutputTableHandle beginWriteTable(ConnectorTableMetadata tableMetadata) {
        try {
            return this.createTable(tableMetadata, this.generateTemporaryTableName());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorTableMetadata tableMetadata, String tableName) throws SQLException {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schema = schemaTableName.getSchemaName();
        String table = schemaTableName.getTableName();
        if (!this.getSchemaNames().contains(schema)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema not found: " + schema);
        }
        try (Connection connection = this.connectionFactory.openConnection();){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            if (uppercase) {
                schema = schema.toUpperCase(Locale.ENGLISH);
                table = table.toUpperCase(Locale.ENGLISH);
                tableName = tableName.toUpperCase(Locale.ENGLISH);
            }
            String catalog = connection.getCatalog();
            StringBuilder sql = new StringBuilder().append("CREATE TABLE ").append(this.quoted(catalog, schema, tableName)).append(" (");
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder columnList = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                String columnName = column.getName();
                if (uppercase) {
                    columnName = columnName.toUpperCase(Locale.ENGLISH);
                }
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                columnList.add((Object)this.getColumnString(column, columnName));
            }
            Joiner.on((String)", ").appendTo(sql, (Iterable)columnList.build());
            sql.append(")");
            this.execute(connection, sql.toString());
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(this.connectorId, catalog, schema, table, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableName);
            return jdbcOutputTableHandle;
        }
    }

    private String getColumnString(ColumnMetadata column, String columnName) {
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ").append(this.toSqlType(column.getType()));
        if (!column.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    protected String generateTemporaryTableName() {
        return "tmp_presto_" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void commitCreateTable(JdbcOutputTableHandle handle) {
        this.renameTable(handle.getCatalogName(), new SchemaTableName(handle.getSchemaName(), handle.getTemporaryTableName()), new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void renameTable(JdbcTableHandle handle, SchemaTableName newTable) {
        this.renameTable(handle.getCatalogName(), handle.getSchemaTableName(), newTable);
    }

    protected void renameTable(String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            String schemaName = oldTable.getSchemaName();
            String tableName = oldTable.getTableName();
            String newSchemaName = newTable.getSchemaName();
            String newTableName = newTable.getTableName();
            if (metadata.storesUpperCaseIdentifiers()) {
                schemaName = schemaName.toUpperCase(Locale.ENGLISH);
                tableName = tableName.toUpperCase(Locale.ENGLISH);
                newSchemaName = newSchemaName.toUpperCase(Locale.ENGLISH);
                newTableName = newTableName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(catalogName, newSchemaName, newTableName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void finishInsertTable(JdbcOutputTableHandle handle) {
        Throwable throwable;
        Connection connection;
        String temporaryTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName());
        String targetTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName());
        String insertSql = String.format("INSERT INTO %s SELECT * FROM %s", targetTable, temporaryTable);
        String cleanupSql = "DROP TABLE " + temporaryTable;
        try {
            connection = this.getConnection(handle);
            throwable = null;
            try {
                this.execute(connection, insertSql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            connection = this.getConnection(handle);
            throwable = null;
            try {
                this.execute(connection, cleanupSql);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.warn((Throwable)e, "Failed to cleanup temporary table: %s", new Object[]{temporaryTable});
        }
    }

    @Override
    public void addColumn(JdbcTableHandle handle, ColumnMetadata column) {
        try (Connection connection = this.connectionFactory.openConnection();){
            String schema = handle.getSchemaName();
            String table = handle.getTableName();
            String columnName = column.getName();
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                schema = schema != null ? schema.toUpperCase(Locale.ENGLISH) : null;
                table = table.toUpperCase(Locale.ENGLISH);
                columnName = columnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s ADD %s", this.quoted(handle.getCatalogName(), schema, table), this.getColumnString(column, columnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameColumn(JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), jdbcColumn.getColumnName(), newColumnName);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropColumn(JdbcTableHandle handle, JdbcColumnHandle column) {
        try (Connection connection = this.connectionFactory.openConnection();){
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), column.getColumnName());
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(JdbcTableHandle handle) {
        StringBuilder sql = new StringBuilder().append("DROP TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()));
        try (Connection connection = this.connectionFactory.openConnection();){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void rollbackCreateTable(JdbcOutputTableHandle handle) {
        this.dropTable(new JdbcTableHandle(handle.getConnectorId(), new SchemaTableName(handle.getSchemaName(), handle.getTemporaryTableName()), handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()));
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle) {
        String vars = Joiner.on((char)',').join(Collections.nCopies(handle.getColumnNames().size(), "?"));
        return "INSERT INTO " + this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()) + " VALUES (" + vars + ")";
    }

    @Override
    public Connection getConnection(JdbcOutputTableHandle handle) throws SQLException {
        return this.connectionFactory.openConnection();
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    protected ResultSet getTables(Connection connection, String schemaName, String tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String escape = metadata.getSearchStringEscape();
        return metadata.getTables(connection.getCatalog(), BaseJdbcClient.escapeNamePattern(schemaName, escape), BaseJdbcClient.escapeNamePattern(tableName, escape), new String[]{"TABLE", "VIEW"});
    }

    protected SchemaTableName getSchemaTableName(ResultSet resultSet) throws SQLException {
        return new SchemaTableName(resultSet.getString("TABLE_SCHEM").toLowerCase(Locale.ENGLISH), resultSet.getString("TABLE_NAME").toLowerCase(Locale.ENGLISH));
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return TableStatistics.empty();
    }

    protected void execute(Connection connection, String query) throws SQLException {
        try (Statement statement = connection.createStatement();){
            log.debug("Execute: %s", new Object[]{query});
            statement.execute(query);
        }
    }

    protected String toSqlType(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return "varchar";
            }
            return "varchar(" + varcharType.getLengthSafe() + ")";
        }
        if (type instanceof CharType) {
            if (((CharType)type).getLength() == 65536) {
                return "char";
            }
            return "char(" + ((CharType)type).getLength() + ")";
        }
        if (type instanceof DecimalType) {
            return String.format("decimal(%s, %s)", ((DecimalType)type).getPrecision(), ((DecimalType)type).getScale());
        }
        String sqlType = SQL_TYPES.get(type);
        if (sqlType != null) {
            return sqlType;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    protected String quoted(String catalog, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected static String escapeNamePattern(String name, String escape) {
        if (name == null || escape == null) {
            return name;
        }
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    private static ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        String escape = metadata.getSearchStringEscape();
        return metadata.getColumns(tableHandle.getCatalogName(), BaseJdbcClient.escapeNamePattern(tableHandle.getSchemaName(), escape), BaseJdbcClient.escapeNamePattern(tableHandle.getTableName(), escape), null);
    }
}

