/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;

    public DriverConnectionFactory(Driver driver, BaseJdbcConfig config) {
        this(driver, config.getConnectionUrl(), DriverConnectionFactory.basicConnectionProperties(config));
    }

    public static Properties basicConnectionProperties(BaseJdbcConfig config) {
        Properties connectionProperties = new Properties();
        if (config.getConnectionUser() != null) {
            connectionProperties.setProperty("user", config.getConnectionUser());
        }
        if (config.getConnectionPassword() != null) {
            connectionProperties.setProperty("password", config.getConnectionPassword());
        }
        return connectionProperties;
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "basicConnectionProperties is null"));
    }

    @Override
    public Connection openConnection() throws SQLException {
        Connection connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection");
        return connection;
    }
}

