/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.TableStatistics;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public interface JdbcClient {
    default public boolean schemaExists(String schema) {
        return this.getSchemaNames().contains(schema);
    }

    public Set<String> getSchemaNames();

    public List<SchemaTableName> getTableNames(@Nullable String var1);

    @Nullable
    public JdbcTableHandle getTableHandle(SchemaTableName var1);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ReadMapping> toPrestoType(ConnectorSession var1, JdbcTypeHandle var2);

    public ConnectorSplitSource getSplits(JdbcTableLayoutHandle var1);

    public Connection getConnection(JdbcSplit var1) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedStatement buildSql(Connection var1, JdbcSplit var2, List<JdbcColumnHandle> var3) throws SQLException;

    public void addColumn(JdbcTableHandle var1, ColumnMetadata var2);

    public void dropColumn(JdbcTableHandle var1, JdbcColumnHandle var2);

    public void renameColumn(JdbcTableHandle var1, JdbcColumnHandle var2, String var3);

    public void renameTable(JdbcTableHandle var1, SchemaTableName var2);

    public void createTable(ConnectorTableMetadata var1);

    public JdbcOutputTableHandle beginCreateTable(ConnectorTableMetadata var1);

    public void commitCreateTable(JdbcOutputTableHandle var1);

    public JdbcOutputTableHandle beginInsertTable(ConnectorTableMetadata var1);

    public void finishInsertTable(JdbcOutputTableHandle var1);

    public void dropTable(JdbcTableHandle var1);

    public void rollbackCreateTable(JdbcOutputTableHandle var1);

    public String buildInsertSql(JdbcOutputTableHandle var1);

    public Connection getConnection(JdbcOutputTableHandle var1) throws SQLException;

    public PreparedStatement getPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, TupleDomain<ColumnHandle> var3);
}

