/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class JdbcMetadata
implements ConnectorMetadata {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public JdbcMetadata(JdbcClient jdbcClient, boolean allowDropTable) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
        this.allowDropTable = allowDropTable;
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.jdbcClient.schemaExists(schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.jdbcClient.getSchemaNames());
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getTableHandle(tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new JdbcTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        ImmutableList.Builder columnMetadata = ImmutableList.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, handle)) {
            columnMetadata.add((Object)column.getColumnMetadata());
        }
        return new ConnectorTableMetadata(handle.getSchemaTableName(), (List)columnMetadata.build());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.jdbcClient.getTableNames(schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, jdbcTableHandle)) {
            columnHandles.put((Object)column.getColumnMetadata().getName(), (Object)column);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tables = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listTables(session, prefix.getSchemaName());
        for (SchemaTableName tableName : tables) {
            try {
                JdbcTableHandle tableHandle = this.jdbcClient.getTableHandle(tableName);
                if (tableHandle == null) continue;
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableHandle).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JdbcColumnHandle)columnHandle).getColumnMetadata();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this catalog");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        this.jdbcClient.dropTable(handle);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        JdbcOutputTableHandle handle = this.jdbcClient.beginCreateTable(tableMetadata);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(handle));
        return handle;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.jdbcClient.createTable(tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle handle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.commitCreateTable(handle);
        this.clearRollback();
        return Optional.empty();
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcOutputTableHandle handle = this.jdbcClient.beginInsertTable(this.getTableMetadata(session, tableHandle));
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(handle));
        return handle;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle jdbcInsertHandle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.finishInsertTable(jdbcInsertHandle);
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        this.jdbcClient.addColumn(tableHandle, columnMetadata);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        this.jdbcClient.dropColumn(tableHandle, columnHandle);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, String target) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        this.jdbcClient.renameColumn(tableHandle, columnHandle, target);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle table, SchemaTableName newTableName) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        this.jdbcClient.renameTable(tableHandle, newTableName);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        return this.jdbcClient.getTableStatistics(session, handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
    }
}

