/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class QueryBuilder {
    private static final String ALWAYS_TRUE = "1=1";
    private static final String ALWAYS_FALSE = "1=0";
    private final String quote;

    public QueryBuilder(String quote) {
        this.quote = Objects.requireNonNull(quote, "quote is null");
    }

    public PreparedStatement buildSql(JdbcClient client, Connection connection, String catalog, String schema, String table, List<JdbcColumnHandle> columns, TupleDomain<ColumnHandle> tupleDomain, Optional<String> additionalPredicate) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String columnNames = columns.stream().map(JdbcColumnHandle::getColumnName).map(this::quote).collect(Collectors.joining(", "));
        sql.append("SELECT ");
        sql.append(columnNames);
        if (columns.isEmpty()) {
            sql.append("null");
        }
        sql.append(" FROM ");
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sql.append(this.quote(catalog)).append('.');
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sql.append(this.quote(schema)).append('.');
        }
        sql.append(this.quote(table));
        ArrayList<TypeAndValue> accumulator = new ArrayList<TypeAndValue>();
        ImmutableList clauses = this.toConjuncts(columns, tupleDomain, accumulator);
        if (additionalPredicate.isPresent()) {
            clauses = ImmutableList.builder().addAll(clauses).add((Object)additionalPredicate.get()).build();
        }
        if (!clauses.isEmpty()) {
            sql.append(" WHERE ").append(Joiner.on((String)" AND ").join((Iterable)clauses));
        }
        PreparedStatement statement = client.getPreparedStatement(connection, sql.toString());
        for (int i = 0; i < accumulator.size(); ++i) {
            TypeAndValue typeAndValue = (TypeAndValue)accumulator.get(i);
            if (typeAndValue.getType().equals(BigintType.BIGINT)) {
                statement.setLong(i + 1, (Long)typeAndValue.getValue());
                continue;
            }
            if (typeAndValue.getType().equals(IntegerType.INTEGER)) {
                statement.setInt(i + 1, ((Number)typeAndValue.getValue()).intValue());
                continue;
            }
            if (typeAndValue.getType().equals(SmallintType.SMALLINT)) {
                statement.setShort(i + 1, ((Number)typeAndValue.getValue()).shortValue());
                continue;
            }
            if (typeAndValue.getType().equals(TinyintType.TINYINT)) {
                statement.setByte(i + 1, ((Number)typeAndValue.getValue()).byteValue());
                continue;
            }
            if (typeAndValue.getType().equals(DoubleType.DOUBLE)) {
                statement.setDouble(i + 1, (Double)typeAndValue.getValue());
                continue;
            }
            if (typeAndValue.getType().equals(RealType.REAL)) {
                statement.setFloat(i + 1, Float.intBitsToFloat(((Number)typeAndValue.getValue()).intValue()));
                continue;
            }
            if (typeAndValue.getType().equals(BooleanType.BOOLEAN)) {
                statement.setBoolean(i + 1, (Boolean)typeAndValue.getValue());
                continue;
            }
            if (typeAndValue.getType().equals(DateType.DATE)) {
                long millis = TimeUnit.DAYS.toMillis((Long)typeAndValue.getValue());
                statement.setDate(i + 1, new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis)));
                continue;
            }
            if (typeAndValue.getType().equals(TimeType.TIME)) {
                statement.setTime(i + 1, new Time((Long)typeAndValue.getValue()));
                continue;
            }
            if (typeAndValue.getType().equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                statement.setTime(i + 1, new Time(DateTimeEncoding.unpackMillisUtc((long)((Long)typeAndValue.getValue()))));
                continue;
            }
            if (typeAndValue.getType().equals(TimestampType.TIMESTAMP)) {
                statement.setTimestamp(i + 1, new Timestamp((Long)typeAndValue.getValue()));
                continue;
            }
            if (typeAndValue.getType().equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
                statement.setTimestamp(i + 1, new Timestamp(DateTimeEncoding.unpackMillisUtc((long)((Long)typeAndValue.getValue()))));
                continue;
            }
            if (typeAndValue.getType() instanceof VarcharType) {
                statement.setString(i + 1, ((Slice)typeAndValue.getValue()).toStringUtf8());
                continue;
            }
            if (typeAndValue.getType() instanceof CharType) {
                statement.setString(i + 1, ((Slice)typeAndValue.getValue()).toStringUtf8());
                continue;
            }
            throw new UnsupportedOperationException("Can't handle type: " + typeAndValue.getType());
        }
        return statement;
    }

    private static boolean isAcceptedType(Type type) {
        Type validType = Objects.requireNonNull(type, "type is null");
        return validType.equals(BigintType.BIGINT) || validType.equals(TinyintType.TINYINT) || validType.equals(SmallintType.SMALLINT) || validType.equals(IntegerType.INTEGER) || validType.equals(DoubleType.DOUBLE) || validType.equals(RealType.REAL) || validType.equals(BooleanType.BOOLEAN) || validType.equals(DateType.DATE) || validType.equals(TimeType.TIME) || validType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || validType.equals(TimestampType.TIMESTAMP) || validType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || validType instanceof VarcharType || validType instanceof CharType;
    }

    private List<String> toConjuncts(List<JdbcColumnHandle> columns, TupleDomain<ColumnHandle> tupleDomain, List<TypeAndValue> accumulator) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JdbcColumnHandle column : columns) {
            Domain domain;
            Type type = column.getColumnType();
            if (!QueryBuilder.isAcceptedType(type) || (domain = (Domain)((Map)tupleDomain.getDomains().get()).get(column)) == null) continue;
            builder.add((Object)this.toPredicate(column.getColumnName(), domain, type, accumulator));
        }
        return builder.build();
    }

    private String toPredicate(String columnName, Domain domain, Type type, List<TypeAndValue> accumulator) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? this.quote(columnName) + " IS NULL" : ALWAYS_FALSE;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? ALWAYS_TRUE : this.quote(columnName) + " IS NOT NULL";
        }
        ArrayList<String> disjuncts = new ArrayList<String>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getLow().getValue());
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">", range.getLow().getValue(), type, accumulator));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">=", range.getLow().getValue(), type, accumulator));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalArgumentException("Low marker should never use BELOW bound");
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High marker should never use ABOVE bound");
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<=", range.getHigh().getValue(), type, accumulator));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<", range.getHigh().getValue(), type, accumulator));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.toPredicate(columnName, "=", Iterables.getOnlyElement(singleValues), type, accumulator));
        } else if (singleValues.size() > 1) {
            for (Object e : singleValues) {
                QueryBuilder.bindValue(e, type, accumulator);
            }
            String values = Joiner.on((String)",").join(Collections.nCopies(singleValues.size(), "?"));
            disjuncts.add(this.quote(columnName) + " IN (" + values + ")");
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.quote(columnName) + " IS NULL");
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private String toPredicate(String columnName, String operator, Object value, Type type, List<TypeAndValue> accumulator) {
        QueryBuilder.bindValue(value, type, accumulator);
        return this.quote(columnName) + " " + operator + " ?";
    }

    private String quote(String name) {
        name = name.replace(this.quote, this.quote + this.quote);
        return this.quote + name + this.quote;
    }

    private static void bindValue(Object value, Type type, List<TypeAndValue> accumulator) {
        Preconditions.checkArgument((boolean)QueryBuilder.isAcceptedType(type), (String)"Can't handle type: %s", (Object)type);
        accumulator.add(new TypeAndValue(type, value));
    }

    private static class TypeAndValue {
        private final Type type;
        private final Object value;

        public TypeAndValue(Type type, Object value) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

