/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.validation.Path;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathNavigation;
import org.apache.bval.util.Comparators;
import org.apache.bval.util.Exceptions;

public class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comparator<Path> PATH_COMPARATOR = Comparators.comparingIterables(NodeImpl.NODE_COMPARATOR);
    static final String PROPERTY_PATH_SEPARATOR = ".";
    private final LinkedList<NodeImpl> nodeList = new LinkedList();

    public static PathImpl createPathFromString(String propertyPath) {
        if (propertyPath == null || propertyPath.isEmpty()) {
            return PathImpl.create();
        }
        return PathNavigation.navigateAndReturn(propertyPath, new Builder());
    }

    public static PathImpl create() {
        PathImpl path = new PathImpl();
        NodeImpl.BeanNodeImpl node = new NodeImpl.BeanNodeImpl();
        path.addNode(node);
        return path;
    }

    public static PathImpl copy(Path path) {
        return path == null ? null : new PathImpl((Iterable<? extends Path.Node>)path);
    }

    public static PathImpl of(Path path) {
        return path instanceof PathImpl ? (PathImpl)path : PathImpl.copy(path);
    }

    private static NodeImpl newNode(Path.Node cast) {
        if (Path.BeanNode.class.isInstance(cast)) {
            return new NodeImpl.BeanNodeImpl(cast);
        }
        if (Path.MethodNode.class.isInstance(cast)) {
            return new NodeImpl.MethodNodeImpl(cast);
        }
        if (Path.ConstructorNode.class.isInstance(cast)) {
            return new NodeImpl.ConstructorNodeImpl(cast);
        }
        if (Path.ReturnValueNode.class.isInstance(cast)) {
            return new NodeImpl.ReturnValueNodeImpl(cast);
        }
        if (Path.ParameterNode.class.isInstance(cast)) {
            return new NodeImpl.ParameterNodeImpl(cast);
        }
        if (Path.CrossParameterNode.class.isInstance(cast)) {
            return new NodeImpl.CrossParameterNodeImpl(cast);
        }
        if (Path.ContainerElementNode.class.isInstance(cast)) {
            return new NodeImpl.ContainerElementNodeImpl(cast);
        }
        return new NodeImpl.PropertyNodeImpl(cast);
    }

    private static boolean isAwaitingPropertyName(NodeImpl n) {
        return n != null && n.getName() == null && (n.isInIterable() || n.getContainerClass() != null);
    }

    private PathImpl() {
    }

    private PathImpl(Iterable<? extends Path.Node> nodes) {
        nodes.forEach(n -> this.nodeList.add(PathImpl.newNode(n)));
    }

    public boolean isRootPath() {
        if (this.nodeList.size() != 1) {
            return false;
        }
        Path.Node first = this.nodeList.peekFirst();
        return !first.isInIterable() && first.getName() == null;
    }

    public PathImpl addNode(Path.Node node) {
        NodeImpl impl;
        NodeImpl nodeImpl = impl = node instanceof NodeImpl ? (NodeImpl)node : PathImpl.newNode(node);
        if (this.isRootPath()) {
            this.nodeList.pop();
        }
        this.nodeList.add(impl);
        return this;
    }

    public PathImpl addProperty(String name) {
        NodeImpl leaf;
        if (!this.nodeList.isEmpty() && PathImpl.isAwaitingPropertyName(leaf = this.getLeafNode())) {
            if (!Path.PropertyNode.class.isInstance(leaf)) {
                NodeImpl.PropertyNodeImpl tmp = new NodeImpl.PropertyNodeImpl(leaf);
                this.removeLeafNode();
                this.addNode(tmp);
                leaf = tmp;
            }
            leaf.setName(name);
            return this;
        }
        return this.addNode(new NodeImpl.PropertyNodeImpl(name));
    }

    public PathImpl addBean() {
        NodeImpl.BeanNodeImpl node = !this.nodeList.isEmpty() && PathImpl.isAwaitingPropertyName(this.getLeafNode()) ? new NodeImpl.BeanNodeImpl(this.removeLeafNode()) : new NodeImpl.BeanNodeImpl();
        return this.addNode(node);
    }

    public NodeImpl removeLeafNode() {
        Exceptions.raiseIf(this.isRootPath() || this.nodeList.isEmpty(), IllegalStateException::new, "No nodes in path!", new Object[0]);
        try {
            NodeImpl nodeImpl = this.nodeList.removeLast();
            return nodeImpl;
        }
        finally {
            if (this.nodeList.isEmpty()) {
                this.nodeList.add(new NodeImpl.BeanNodeImpl());
            }
        }
    }

    public NodeImpl getLeafNode() {
        if (this.nodeList.isEmpty()) {
            return null;
        }
        return this.nodeList.peekLast();
    }

    public Iterator<Path.Node> iterator() {
        Iterator<Path.Node> result = this.nodeList.iterator();
        return result;
    }

    public boolean isSubPathOf(Path path) {
        if (path instanceof PathImpl && ((PathImpl)path).isRootPath()) {
            return true;
        }
        Iterator pathIter = path.iterator();
        Iterator<Path.Node> thisIter = this.iterator();
        while (pathIter.hasNext()) {
            Path.Node pathNode = (Path.Node)pathIter.next();
            if (!thisIter.hasNext()) {
                return false;
            }
            Path.Node thisNode = thisIter.next();
            if (pathNode.isInIterable()) {
                if (!thisNode.isInIterable()) {
                    return false;
                }
                if (pathNode.getIndex() != null && !pathNode.getIndex().equals(thisNode.getIndex())) {
                    return false;
                }
                if (pathNode.getKey() != null && !pathNode.getKey().equals(thisNode.getKey())) {
                    return false;
                }
            } else if (thisNode.isInIterable()) {
                return false;
            }
            if (pathNode.getName() == null || pathNode.getName().equals(thisNode.getName())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path.Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            Path.Node node = iterator.next();
            NodeImpl.appendNode(node, builder);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return Objects.equals(this.nodeList, ((PathImpl)o).nodeList);
    }

    public int hashCode() {
        return Objects.hashCode(this.nodeList);
    }

    public static class Builder
    implements PathNavigation.Callback<PathImpl> {
        private final PathImpl result = PathImpl.create();

        @Override
        public void handleProperty(String name) {
            this.result.addProperty(name);
        }

        @Override
        public void handleIndexOrKey(String value) {
            NodeImpl node;
            try {
                node = NodeImpl.atIndex(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                node = NodeImpl.atKey(value);
            }
            this.result.addNode(node);
        }

        @Override
        public PathImpl result() {
            return this.result;
        }

        @Override
        public void handleGenericInIterable() {
            this.result.addNode(NodeImpl.atIndex(null));
        }
    }
}

