/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.facebook.airlift.concurrent.Threads;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConcurrentScheduledExecutor
implements ScheduledExecutorService {
    private final List<ScheduledExecutorService> schedulers;

    public ConcurrentScheduledExecutor(int schedulerCount, int threadsPerScheduler, String threadBaseName) {
        this(schedulerCount, threadsPerScheduler, threadBaseName, false);
    }

    public ConcurrentScheduledExecutor(int schedulerCount, int threadsPerScheduler, String threadBaseName, boolean removeOnCancel) {
        Preconditions.checkArgument((schedulerCount > 0 ? 1 : 0) != 0, (Object)"schedulerCount must be at least one");
        Preconditions.checkArgument((threadsPerScheduler > 0 ? 1 : 0) != 0, (Object)"threadsPerScheduler must be at least one");
        Objects.requireNonNull(threadBaseName, "threadBaseName is null");
        ImmutableList.Builder schedulersBuilder = ImmutableList.builder();
        for (int i = 0; i < schedulerCount; ++i) {
            ThreadFactory threadFactory = Threads.daemonThreadsNamed(threadBaseName + String.format("-scheduler-%d", i) + "-%s");
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(threadsPerScheduler, threadFactory);
            scheduledExecutorService.setRemoveOnCancelPolicy(removeOnCancel);
            schedulersBuilder.add((Object)scheduledExecutorService);
        }
        this.schedulers = schedulersBuilder.build();
    }

    public static ConcurrentScheduledExecutor createConcurrentScheduledExecutor(String threadBaseName, int concurrency, int totalThreads) {
        Preconditions.checkArgument((concurrency >= 1 ? 1 : 0) != 0, (Object)"concurrency must be at least one");
        int threadsPerScheduler = Math.max(1, totalThreads / concurrency);
        return new ConcurrentScheduledExecutor(concurrency, threadsPerScheduler, threadBaseName);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getRandomScheduler().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.getRandomScheduler().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getRandomScheduler().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getRandomScheduler().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return (List)this.schedulers.stream().map(ExecutorService::shutdownNow).flatMap(list -> list.stream()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean isShutdown() {
        return this.schedulers.stream().allMatch(ExecutorService::isShutdown);
    }

    @Override
    public boolean isTerminated() {
        return this.schedulers.stream().allMatch(ExecutorService::isTerminated);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long timeoutMillis = unit.toMillis(timeout);
        boolean awaitResult = true;
        for (ScheduledExecutorService executor : this.schedulers) {
            long duration = System.currentTimeMillis() - startTime;
            awaitResult = duration < timeoutMillis ? (awaitResult &= executor.awaitTermination(timeoutMillis - duration, TimeUnit.MILLISECONDS)) : (awaitResult &= executor.isTerminated());
            if (awaitResult) continue;
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.schedulers.stream().forEach(ExecutorService::shutdown);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getRandomScheduler().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getRandomScheduler().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getRandomScheduler().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getRandomScheduler().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getRandomScheduler().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getRandomScheduler().invokeAny(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getRandomScheduler().invokeAny(tasks);
    }

    @Override
    public void execute(Runnable command) {
        this.getRandomScheduler().execute(command);
    }

    private ScheduledExecutorService getRandomScheduler() {
        return this.schedulers.get(ThreadLocalRandom.current().nextInt(this.schedulers.size()));
    }
}

