/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcPageSink;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcPageSinkProvider
implements ConnectorPageSinkProvider {
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcPageSinkProvider(JdbcClient jdbcClient) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Jdbc connector does not support page sink commit");
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Jdbc connector does not support page sink commit");
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient);
    }
}

