/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import java.util.Objects;

public class JdbcPlugin
implements Plugin {
    private final String name;
    private final Module module;

    public JdbcPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new JdbcConnectorFactory(this.name, this.module, JdbcPlugin.getClassLoader()));
    }

    private static ClassLoader getClassLoader() {
        return (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)JdbcPlugin.class.getClassLoader());
    }
}

