/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.google.common.annotations.Beta;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

@Beta
public class ThreadPoolExecutorMBean {
    private final ThreadPoolExecutor threadPoolExecutor;

    public ThreadPoolExecutorMBean(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = Objects.requireNonNull(threadPoolExecutor, "threadPoolExecutor is null");
    }

    @Managed
    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Managed
    public boolean isTerminating() {
        return this.threadPoolExecutor.isTerminating();
    }

    @Managed
    public boolean isTerminated() {
        return this.threadPoolExecutor.isTerminated();
    }

    @Managed
    public String getRejectedExecutionHandler() {
        return this.threadPoolExecutor.getRejectedExecutionHandler().getClass().getName();
    }

    @Managed
    public int getCorePoolSize() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    @Managed
    public void setCorePoolSize(int corePoolSize) {
        this.threadPoolExecutor.setCorePoolSize(corePoolSize);
    }

    @Managed
    public int getMaximumPoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize();
    }

    @Managed
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.threadPoolExecutor.setMaximumPoolSize(maximumPoolSize);
    }

    @Managed
    public int getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    @Managed
    public int getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Managed
    public int getLargestPoolSize() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    @Managed
    public String getKeepAliveTime() {
        return new Duration((double)this.threadPoolExecutor.getKeepAliveTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit().toString();
    }

    @Managed
    public void setKeepAliveTime(String duration) {
        Objects.requireNonNull(duration, "duration is null");
        this.threadPoolExecutor.setKeepAliveTime(Duration.valueOf((String)duration).roundTo(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    @Managed
    public boolean isAllowCoreThreadTimeOut() {
        return this.threadPoolExecutor.allowsCoreThreadTimeOut();
    }

    @Managed
    public void setAllowCoreThreadTimeOut(boolean allowsCoreThreadTimeOut) {
        this.threadPoolExecutor.allowCoreThreadTimeOut(allowsCoreThreadTimeOut);
    }

    @Managed
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Managed
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }

    @Managed
    public int getQueuedTaskCount() {
        return this.threadPoolExecutor.getQueue().size();
    }
}

