/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ExecutableValidator;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.ExecutableTypes;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.Proxies;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;

@Interceptor
@BValBinding
@Priority(value=4800)
public class BValInterceptor
implements Serializable {
    private volatile transient Set<ExecutableType> classConfiguration;
    private volatile transient Map<Signature, Boolean> executableValidation;
    @Inject
    private Validator validator;
    @Inject
    private BValExtension globalConfiguration;
    private volatile transient ExecutableValidator executableValidator;

    private static Collection<ExecutableType> removeFrom(Collection<ExecutableType> coll, ExecutableType ... executableTypes) {
        List<ExecutableType> toRemove;
        Validate.notNull(coll, "collection was null", new Object[0]);
        if (!(coll.isEmpty() || ObjectUtils.isEmptyArray(executableTypes) || Collections.disjoint(coll, toRemove = Arrays.asList(executableTypes)))) {
            EnumSet<ExecutableType> result = EnumSet.copyOf(coll);
            result.removeAll(toRemove);
            return result;
        }
        return coll;
    }

    @AroundConstruct
    public Object construct(InvocationContext context) throws Exception {
        Set violations;
        Set violations2;
        Constructor ctor = context.getConstructor();
        if (!this.isConstructorValidated(ctor)) {
            return context.proceed();
        }
        ConstructorDescriptor constraints = this.validator.getConstraintsForClass(ctor.getDeclaringClass()).getConstraintsForConstructor((Class[])ctor.getParameterTypes());
        if (!DescriptorManager.isConstrained(constraints)) {
            return context.proceed();
        }
        this.initExecutableValidator();
        if (constraints.hasConstrainedParameters() && !(violations2 = this.executableValidator.validateConstructorParameters(ctor, context.getParameters(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        Object result = context.proceed();
        if (constraints.hasConstrainedReturnValue() && !(violations = this.executableValidator.validateConstructorReturnValue(ctor, context.getTarget(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return result;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Exception {
        Set violations;
        Set violations2;
        Method method = context.getMethod();
        Class<?> targetClass = Proxies.classFor(context.getTarget().getClass());
        if (!this.isExecutableValidated(targetClass, method, this::computeIsMethodValidated)) {
            return context.proceed();
        }
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(targetClass).getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
        if (!DescriptorManager.isConstrained(constraintsForMethod)) {
            return context.proceed();
        }
        this.initExecutableValidator();
        if (constraintsForMethod.hasConstrainedParameters() && !(violations2 = this.executableValidator.validateParameters(context.getTarget(), method, context.getParameters(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        Object result = context.proceed();
        if (constraintsForMethod.hasConstrainedReturnValue() && !(violations = this.executableValidator.validateReturnValue(context.getTarget(), method, result, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return result;
    }

    private <T> boolean isConstructorValidated(Constructor<T> constructor) {
        return this.isExecutableValidated(constructor.getDeclaringClass(), constructor, this::computeIsConstructorValidated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Executable> boolean isExecutableValidated(Class<T> targetClass, E executable, BiPredicate<? super Class<T>, ? super E> compute) {
        this.initClassConfig(targetClass);
        if (this.executableValidation == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidation == null) {
                    this.executableValidation = new ConcurrentHashMap<Signature, Boolean>();
                }
            }
        }
        return this.executableValidation.computeIfAbsent(Signature.of(executable), s -> compute.test((Object)targetClass, (Object)executable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassConfig(Class<?> targetClass) {
        if (this.classConfiguration == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.classConfiguration == null) {
                    AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(targetClass);
                    this.classConfiguration = annotatedType.isAnnotationPresent(ValidateOnExecution.class) ? ExecutableTypes.interpret(BValInterceptor.removeFrom(Arrays.asList(((ValidateOnExecution)annotatedType.getAnnotation(ValidateOnExecution.class)).type()), ExecutableType.IMPLICIT)) : this.globalConfiguration.getGlobalExecutableTypes();
                }
            }
        }
    }

    private <T> boolean computeIsConstructorValidated(Class<T> targetClass, Constructor<T> ctor) {
        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(ctor.getDeclaringClass());
        ValidateOnExecution annotation = annotatedType.getConstructors().stream().filter(ac -> ctor.equals(ac.getJavaMember())).findFirst().map(ac -> (ValidateOnExecution)ac.getAnnotation(ValidateOnExecution.class)).orElseGet(() -> ctor.getAnnotation(ValidateOnExecution.class));
        Set<ExecutableType> validatedExecutableTypes = annotation == null ? this.classConfiguration : ExecutableTypes.interpret(annotation.type());
        return validatedExecutableTypes.contains(ExecutableType.CONSTRUCTORS);
    }

    private <T> boolean computeIsMethodValidated(Class<T> targetClass, Method method) {
        Collection<Object> declaredExecutableTypes;
        Signature signature = Signature.of(method);
        AnnotatedMethod declaringMethod = null;
        for (Class<?> c : Reflection.hierarchy(targetClass, Reflection.Interfaces.INCLUDE)) {
            AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(c);
            AnnotatedMethod annotatedMethod = annotatedType.getMethods().stream().filter(am -> Signature.of(am.getJavaMember()).equals(signature)).findFirst().orElse(null);
            if (annotatedMethod == null) continue;
            declaringMethod = annotatedMethod;
        }
        if (declaringMethod == null) {
            return false;
        }
        if (declaringMethod.isAnnotationPresent(ValidateOnExecution.class)) {
            List<ExecutableType> validatedTypesOnMethod = Arrays.asList(((ValidateOnExecution)declaringMethod.getAnnotation(ValidateOnExecution.class)).type());
            if (validatedTypesOnMethod.contains(ExecutableType.IMPLICIT)) {
                return true;
            }
            declaredExecutableTypes = validatedTypesOnMethod;
        } else {
            Package pkg;
            AnnotatedType declaringType = declaringMethod.getDeclaringType();
            declaredExecutableTypes = declaringType.isAnnotationPresent(ValidateOnExecution.class) ? BValInterceptor.removeFrom(Arrays.asList(((ValidateOnExecution)declaringType.getAnnotation(ValidateOnExecution.class)).type()), ExecutableType.IMPLICIT) : ((pkg = declaringType.getJavaClass().getPackage()) != null && pkg.isAnnotationPresent(ValidateOnExecution.class) ? BValInterceptor.removeFrom(Arrays.asList(pkg.getAnnotation(ValidateOnExecution.class).type()), ExecutableType.IMPLICIT) : null);
        }
        ExecutableType methodType = Methods.isGetter(method) ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS;
        return Optional.ofNullable(declaredExecutableTypes).map(ExecutableTypes::interpret).orElse(this.globalConfiguration.getGlobalExecutableTypes()).contains(methodType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecutableValidator() {
        if (this.executableValidator == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidator == null) {
                    this.executableValidator = this.validator.forExecutables();
                }
            }
        }
    }
}

