/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.CascadingPropertyValidator;
import org.apache.bval.jsr.job.ValidationJobFactory;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;

public class ValidatorImpl
implements CascadingPropertyValidator,
ExecutableValidator {
    private final ApacheFactoryContext validatorContext;
    private final ValidationJobFactory validationJobFactory;

    ValidatorImpl(ApacheFactoryContext validatorContext) {
        this.validatorContext = Validate.notNull(validatorContext, "validatorContext", new Object[0]);
        this.validationJobFactory = new ValidationJobFactory(validatorContext);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validatorContext.getDescriptorManager().getBeanDescriptor(clazz);
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.validationJobFactory.validateBean(object, groups).getResults();
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, boolean cascade, Class<?> ... groups) {
        return this.validationJobFactory.validateProperty(object, propertyName, groups).cascade(cascade).getResults();
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, boolean cascade, Class<?> ... groups) {
        return this.validationJobFactory.validateValue(beanType, propertyName, value, groups).cascade(cascade).getResults();
    }

    public ExecutableValidator forExecutables() {
        return this;
    }

    public <T> Set<ConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        return this.validationJobFactory.validateParameters(object, method, parameterValues, groups).getResults();
    }

    public <T> Set<ConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        return this.validationJobFactory.validateReturnValue(object, method, returnValue, groups).getResults();
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        return this.validationJobFactory.validateConstructorParameters(constructor, parameterValues, groups).getResults();
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        return this.validationJobFactory.validateConstructorReturnValue(constructor, createdObject, groups).getResults();
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            ValidatorImpl result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return this.newInstance(type);
        }
        try {
            Class<?> cls = Reflection.toClass(type.getName() + "Impl");
            if (type.isAssignableFrom(cls)) {
                Class<?> implClass = cls;
                return (T)this.newInstance(implClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    private <T> T newInstance(Class<T> cls) {
        Constructor<T> cons = Reflection.getDeclaredConstructor(cls, ApacheFactoryContext.class);
        if (cons == null) {
            throw new ValidationException("Cannot instantiate " + cls);
        }
        boolean mustUnset = Reflection.setAccessible(cons, true);
        try {
            T t = cons.newInstance(this.validatorContext);
            return t;
        }
        catch (Exception ex) {
            throw new ValidationException("Cannot instantiate " + cls, (Throwable)ex);
        }
        finally {
            if (mustUnset) {
                Reflection.setAccessible(cons, false);
            }
        }
    }
}

