/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Set;
import javax.validation.metadata.CascadableDescriptor;
import javax.validation.metadata.ContainerDescriptor;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import org.apache.bval.jsr.descriptor.ContainerElementTypeD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class CascadableContainerD<P extends ElementD<?, ?>, E extends AnnotatedElement>
extends ElementD.NonRoot<P, E, MetadataReader.ForContainer<E>>
implements CascadableDescriptor,
ContainerDescriptor {
    private final boolean cascaded;
    private final Set<GroupConversion> groupConversions;
    private final Set<ContainerElementTypeD> containerElementTypes;

    protected CascadableContainerD(MetadataReader.ForContainer<E> reader, P parent) {
        super(reader, parent);
        this.cascaded = reader.isCascaded();
        this.groupConversions = reader.getGroupConversions();
        this.containerElementTypes = reader.getContainerElementTypes(this);
    }

    public Class<?> getElementClass() {
        return TypeUtils.getRawType(this.getGenericType(), this.parent.getElementClass());
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public Set<GroupConversionDescriptor> getGroupConversions() {
        return this.groupConversions;
    }

    public Set<ContainerElementTypeDescriptor> getConstrainedContainerElementTypes() {
        return this.containerElementTypes.stream().filter(DescriptorManager::isConstrained).collect(ToUnmodifiable.set());
    }
}

