/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int maximumCapacity;

    public LRUCache(int maximumCapacity) {
        super(16, 0.75f, true);
        if (maximumCapacity < 1) {
            throw new IllegalArgumentException("maximumCapacity must be > 0");
        }
        this.maximumCapacity = maximumCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return super.removeEldestEntry(eldest) || this.size() >= this.maximumCapacity;
    }
}

