/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.postgresql;

import com.facebook.presto.Session;
import com.facebook.presto.plugin.postgresql.PostgreSqlPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tpch.TpchPlugin;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.airlift.testing.postgresql.TestingPostgreSqlServer;
import io.airlift.tpch.TpchTable;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;

public final class PostgreSqlQueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private PostgreSqlQueryRunner() {
    }

    public static QueryRunner createPostgreSqlQueryRunner(TestingPostgreSqlServer server, TpchTable<?> ... tables) throws Exception {
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(server, ImmutableList.copyOf((Object[])tables));
    }

    public static QueryRunner createPostgreSqlQueryRunner(TestingPostgreSqlServer server, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = new DistributedQueryRunner(PostgreSqlQueryRunner.createSession(), 3);
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            ImmutableMap properties = ImmutableMap.of((Object)"connection-url", (Object)server.getJdbcUrl());
            PostgreSqlQueryRunner.createSchema(server.getJdbcUrl(), TPCH_SCHEMA);
            queryRunner.installPlugin((Plugin)new PostgreSqlPlugin());
            queryRunner.createCatalog("postgresql", "postgresql", (Map)properties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)PostgreSqlQueryRunner.createSession(), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{queryRunner, server});
            throw e;
        }
    }

    private static void createSchema(String url, String schema) throws SQLException {
        try (Connection connection = DriverManager.getConnection(url);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA " + schema);
        }
    }

    public static Session createSession() {
        return Session.builder().setUser("user").setSource("test").setCatalog("postgresql").setSchema(TPCH_SCHEMA).setTimeZoneKey(TimeZoneKey.UTC_KEY).setLocale(Locale.ENGLISH).build();
    }
}

