/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileSystemCache;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HiveClientConfig;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;
    private final boolean verifyChecksum;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration, HiveClientConfig config) {
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        this.verifyChecksum = Objects.requireNonNull(config, "config is null").isVerifyChecksum();
    }

    public Configuration getConfiguration(Path path) {
        return this.hdfsConfiguration.getConfiguration(path.toUri());
    }

    public FileSystem getFileSystem(Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem(this.getConfiguration(path));
        fileSystem.setVerifyChecksum(this.verifyChecksum);
        return fileSystem;
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
    }
}

