/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class HiveColumnHandle
implements ColumnHandle {
    public static final String SAMPLE_WEIGHT_COLUMN_NAME = "__presto__sample_weight__";
    private static final String UPDATE_ROW_ID_COLUMN_NAME = "$shard_row_id";
    private final String clientId;
    private final String name;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final boolean partitionKey;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="partitionKey") boolean partitionKey) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((hiveColumnIndex >= 0 || partitionKey ? 1 : 0) != 0, (Object)"hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.typeName = Objects.requireNonNull(typeSignature, "type is null");
        this.partitionKey = partitionKey;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.name, typeManager.getType(this.typeName));
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.name, this.hiveColumnIndex, this.hiveType, this.partitionKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.name, other.name) && Objects.equals(this.hiveColumnIndex, other.hiveColumnIndex) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals(this.partitionKey, other.partitionKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("name", (Object)this.name).add("hiveType", (Object)this.hiveType).add("hiveColumnIndex", this.hiveColumnIndex).add("partitionKey", this.partitionKey).toString();
    }

    public static HiveColumnHandle toHiveColumnHandle(ColumnHandle columnHandle) {
        return Types.checkType(columnHandle, HiveColumnHandle.class, "columnHandle");
    }

    public static HiveColumnHandle updateRowIdHandle(String connectorId) {
        return new HiveColumnHandle(connectorId, UPDATE_ROW_ID_COLUMN_NAME, HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), -1, true);
    }
}

