/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class HiveMetadataFactory {
    private static final Logger log = Logger.get(HiveMetadataFactory.class);
    private final String connectorId;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowAddColumn;
    private final boolean allowRenameColumn;
    private final boolean allowCorruptWritesForTesting;
    private final boolean respectTableFormat;
    private final HiveStorageFormat defaultStorageFormat;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;

    @Inject
    public HiveMetadataFactory(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHiveClient ExecutorService executorService, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec) {
        this(connectorId, metastore, hdfsEnvironment, partitionManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.getMaxConcurrentFileRenames(), hiveClientConfig.getAllowDropTable(), hiveClientConfig.getAllowRenameTable(), hiveClientConfig.getAllowAddColumn(), hiveClientConfig.getAllowRenameColumn(), hiveClientConfig.getAllowCorruptWritesForTesting(), hiveClientConfig.isRespectTableFormat(), hiveClientConfig.getHiveStorageFormat(), typeManager, locationService, tableParameterCodec, partitionUpdateCodec, executorService);
    }

    public HiveMetadataFactory(HiveConnectorId connectorId, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, int maxConcurrentFileRenames, boolean allowDropTable, boolean allowRenameTable, boolean allowAddColumn, boolean allowRenameColumn, boolean allowCorruptWritesForTesting, boolean respectTableFormat, HiveStorageFormat defaultStorageFormat, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.allowDropTable = allowDropTable;
        this.allowRenameTable = allowRenameTable;
        this.allowAddColumn = allowAddColumn;
        this.allowRenameColumn = allowRenameColumn;
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.respectTableFormat = respectTableFormat;
        this.defaultStorageFormat = Objects.requireNonNull(defaultStorageFormat, "defaultStorageFormat is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
    }

    public HiveMetadata create() {
        return new HiveMetadata(this.connectorId, this.metastore, this.hdfsEnvironment, this.partitionManager, this.timeZone, this.allowDropTable, this.allowRenameTable, this.allowAddColumn, this.allowRenameColumn, this.allowCorruptWritesForTesting, this.respectTableFormat, this.defaultStorageFormat, this.typeManager, this.locationService, this.tableParameterCodec, this.partitionUpdateCodec, (Executor)this.renameExecution);
    }
}

