/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HiveRecordCursorProvider> cursorProviders;
    private final TypeManager typeManager;
    private final Set<HivePageSourceFactory> pageSourceFactories;

    @Inject
    public HivePageSourceProvider(HiveClientConfig hiveClientConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, TypeManager typeManager) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.hiveStorageTimeZone = hiveClientConfig.getDateTimeZone();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.cursorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(cursorProviders, "cursorProviders is null"));
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        HiveSplit hiveSplit = Types.checkType(split, HiveSplit.class, "split");
        String clientId = hiveSplit.getClientId();
        Path path = new Path(hiveSplit.getPath());
        long start = hiveSplit.getStart();
        long length = hiveSplit.getLength();
        Configuration configuration = this.hdfsEnvironment.getConfiguration(path);
        TupleDomain<HiveColumnHandle> effectivePredicate = hiveSplit.getEffectivePredicate();
        Properties schema = hiveSplit.getSchema();
        List<HivePartitionKey> partitionKeys = hiveSplit.getPartitionKeys();
        ImmutableList hiveColumns = ImmutableList.copyOf((Iterable)Iterables.transform(columns, HiveColumnHandle::toHiveColumnHandle));
        for (HivePageSourceFactory pageSourceFactory : this.pageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, start, length, schema, (List<HiveColumnHandle>)hiveColumns, partitionKeys, effectivePredicate, this.hiveStorageTimeZone);
            if (!pageSource.isPresent()) continue;
            return pageSource.get();
        }
        HiveRecordCursor recordCursor = this.getHiveRecordCursor(clientId, session, configuration, path, start, length, schema, effectivePredicate, partitionKeys, (List<HiveColumnHandle>)hiveColumns);
        if (recordCursor != null) {
            ImmutableList columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)hiveColumns, input -> this.typeManager.getType(input.getTypeSignature())));
            return new RecordPageSource((List)columnTypes, (RecordCursor)recordCursor);
        }
        throw new RuntimeException("Could not find a file reader for split " + hiveSplit);
    }

    protected HiveRecordCursor getHiveRecordCursor(String clientId, ConnectorSession session, Configuration configuration, Path path, long start, long length, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> hiveColumns) {
        for (HiveRecordCursorProvider provider : this.cursorProviders) {
            Optional<HiveRecordCursor> cursor = provider.createHiveRecordCursor(clientId, configuration, session, path, start, length, schema, hiveColumns, partitionKeys, effectivePredicate, this.hiveStorageTimeZone, this.typeManager);
            if (!cursor.isPresent()) continue;
            return cursor.get();
        }
        return null;
    }
}

