/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.api.Table;
import org.joda.time.DateTimeZone;

public class HivePartitionManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    private static final String PARTITION_VALUE_WILDCARD = "";
    private final String connectorId;
    private final DateTimeZone timeZone;
    private final boolean assumeCanonicalPartitionKeys;
    private final int domainCompactionThreshold;

    @Inject
    public HivePartitionManager(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig) {
        this(connectorId, hiveClientConfig.getDateTimeZone(), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), hiveClientConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(HiveConnectorId connectorId, DateTimeZone timeZone, int maxOutstandingSplits, boolean assumeCanonicalPartitionKeys, int domainCompactionThreshold) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public HivePartitionResult getPartitions(ConnectorSession session, HiveMetastore metastore, ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> effectivePredicate) {
        HiveTableHandle hiveTableHandle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(metastore, tableName);
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(this.connectorId, table);
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(this.connectorId, table);
        Optional<HiveBucketing.HiveBucket> bucket = HiveBucketing.getHiveBucket(table, (Map)TupleDomain.extractFixedValues(effectivePredicate).get());
        TupleDomain<HiveColumnHandle> compactEffectivePredicate = HivePartitionManager.toCompactTupleDomain(effectivePredicate, this.domainCompactionThreshold);
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, (List<HivePartition>)ImmutableList.of(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle);
        }
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, (List<HivePartition>)ImmutableList.of((Object)new HivePartition(tableName, compactEffectivePredicate, bucket)), effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle);
        }
        List<String> partitionNames = this.getFilteredPartitionNames(metastore, tableName, partitionColumns, effectivePredicate);
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (String partitionName : partitionNames) {
            Optional<Map<ColumnHandle, NullableValue>> values = this.parseValuesAndFilterPartition(partitionName, partitionColumns, effectivePredicate);
            if (!values.isPresent()) continue;
            partitions.add((Object)new HivePartition(tableName, compactEffectivePredicate, partitionName, values.get(), bucket));
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
        TupleDomain enforcedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (Predicate)Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, (List<HivePartition>)partitions.build(), (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle);
    }

    private static TupleDomain<HiveColumnHandle> toCompactTupleDomain(TupleDomain<ColumnHandle> effectivePredicate, int threshold) {
        Preconditions.checkArgument((boolean)effectivePredicate.getDomains().isPresent());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            HiveColumnHandle hiveColumnHandle = Types.checkType(entry.getKey(), HiveColumnHandle.class, "ConnectorColumnHandle");
            ValueSet values = ((Domain)entry.getValue()).getValues();
            ValueSet compactValueSet = ((Optional)values.getValuesProcessor().transform(ranges -> ranges.getRangeCount() > threshold ? Optional.of(ValueSet.ofRanges((Range)ranges.getSpan(), (Range[])new Range[0])) : Optional.empty(), discreteValues -> discreteValues.getValues().size() > threshold ? Optional.of(ValueSet.all((Type)values.getType())) : Optional.empty(), allOrNone -> Optional.empty())).orElse(values);
            builder.put((Object)hiveColumnHandle, (Object)Domain.create((ValueSet)compactValueSet, (boolean)((Domain)entry.getValue()).isNullAllowed()));
        }
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    private Optional<Map<ColumnHandle, NullableValue>> parseValuesAndFilterPartition(String partitionName, List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> predicate) {
        Preconditions.checkArgument((boolean)predicate.getDomains().isPresent());
        List<String> partitionValues = HivePartitionManager.extractPartitionKeyValues(partitionName);
        Map domains = (Map)predicate.getDomains().get();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), column.getHiveType(), this.timeZone);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain != null && !allowedDomain.includesNullableValue(parsedValue.getValue())) {
                return Optional.empty();
            }
            builder.put((Object)column, (Object)parsedValue);
        }
        return Optional.of(builder.build());
    }

    private Table getTable(HiveMetastore metastore, SchemaTableName tableName) {
        Optional<Table> target = metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        String protectMode = (String)table.getParameters().get(ProtectMode.PARAMETER_NAME);
        if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
            throw new TableOfflineException(tableName);
        }
        String prestoOffline = (String)table.getParameters().get(PRESTO_OFFLINE);
        if (!Strings.isNullOrEmpty((String)prestoOffline)) {
            throw new TableOfflineException(tableName, String.format("Table '%s' is offline for Presto: %s", tableName, prestoOffline));
        }
        return table;
    }

    private List<String> getFilteredPartitionNames(HiveMetastore metastore, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ColumnHandle> effectivePredicate) {
        Preconditions.checkArgument((boolean)effectivePredicate.getDomains().isPresent());
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)((Map)effectivePredicate.getDomains().get()).get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Object value = domain.getNullableSingleValue();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (value instanceof Slice) {
                    filter.add(((Slice)value).toStringUtf8());
                    continue;
                }
                if (value instanceof Boolean || value instanceof Double || value instanceof Long) {
                    if (this.assumeCanonicalPartitionKeys) {
                        filter.add(value.toString());
                        continue;
                    }
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only Boolean, Double and Long partition keys are supported");
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        return metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filter).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static List<String> extractPartitionKeyValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }
}

