/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public final class HiveSessionProperties {
    private static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final String OPTIMIZED_READER_ENABLED = "optimized_reader_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String PARQUET_PREDICATE_PUSHDOWN_ENABLED = "parquet_predicate_pushdown_enabled";
    private static final String PARQUET_OPTIMIZED_READER_ENABLED = "parquet_optimized_reader_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveClientConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanSessionProperty((String)FORCE_LOCAL_SCHEDULING, (String)"Only schedule splits on workers colocated with data node", (Boolean)config.isForceLocalScheduling(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", config.getOrcMaxMergeDistance(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", config.getOrcMaxBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", config.getOrcStreamBufferSize(), false), (Object)PropertyMetadata.booleanSessionProperty((String)PARQUET_OPTIMIZED_READER_ENABLED, (String)"Experimental: Parquet: Enable optimized reader", (Boolean)config.isParquetOptimizedReaderEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PARQUET_PREDICATE_PUSHDOWN_ENABLED, (String)"Experimental: Parquet: Enable predicate pushdown for Parquet", (Boolean)config.isParquetPredicatePushdownEnabled(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isForceLocalScheduling(ConnectorSession session) {
        return (Boolean)session.getProperty(FORCE_LOCAL_SCHEDULING, Boolean.class);
    }

    public static boolean isParquetOptimizedReaderEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_READER_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static boolean isParquetPredicatePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_PREDICATE_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.VARCHAR, DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)));
    }
}

