/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcInputFormat;
import com.facebook.hive.orc.OrcOutputFormat;
import com.facebook.hive.orc.OrcSerde;
import java.util.Objects;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public enum HiveStorageFormat {
    ORC(org.apache.hadoop.hive.ql.io.orc.OrcSerde.class.getName(), org.apache.hadoop.hive.ql.io.orc.OrcInputFormat.class.getName(), org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat.class.getName()),
    DWRF(OrcSerde.class.getName(), OrcInputFormat.class.getName(), OrcOutputFormat.class.getName()),
    PARQUET(ParquetHiveSerDe.class.getName(), MapredParquetInputFormat.class.getName(), MapredParquetOutputFormat.class.getName()),
    RCBINARY(LazyBinaryColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName()),
    RCTEXT(ColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName()),
    SEQUENCEFILE(LazySimpleSerDe.class.getName(), SequenceFileInputFormat.class.getName(), HiveSequenceFileOutputFormat.class.getName()),
    TEXTFILE(LazySimpleSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName());

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
    }

    public String getSerDe() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }
}

