/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveReadOnlyException;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.joda.time.DateTimeZone;

public final class HiveWriteUtils {
    private static final FsPermission ALL_PERMISSIONS = new FsPermission(511);

    private HiveWriteUtils() {
    }

    public static FileSinkOperator.RecordWriter createRecordWriter(Path target, JobConf conf, boolean compress, Properties properties, String outputFormatName) {
        try {
            Object writer = Class.forName(outputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            return ((HiveOutputFormat)writer).getHiveRecordWriter(conf, target, Text.class, compress, properties, (Progressable)Reporter.NULL);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    public static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (HiveUtil.isArrayType(type)) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(0)));
        }
        if (HiveUtil.isMapType(type)) {
            ObjectInspector keyObjectInspector = HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (HiveUtil.isRowType(type)) {
            return ObjectInspectorFactory.getStandardStructObjectInspector(type.getTypeSignature().getParameters().stream().map(parameter -> parameter.getNamedTypeSignature().getName()).collect(Collectors.toList()), type.getTypeParameters().stream().map(HiveWriteUtils::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static Object getField(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return type.getBoolean(block, position);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return type.getLong(block, position);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return type.getDouble(block, position);
        }
        if (type instanceof VarcharType) {
            return new Text(type.getSlice(block, position).getBytes());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return type.getSlice(block, position).getBytes();
        }
        if (DateType.DATE.equals((Object)type)) {
            long days = type.getLong(block, position);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), TimeUnit.DAYS.toMillis(days)));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            long millisUtc = type.getLong(block, position);
            return new Timestamp(millisUtc);
        }
        if (HiveUtil.isArrayType(type)) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (HiveUtil.isMapType(type)) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            Block mapBlock = (Block)block.getObject(position, Block.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = HiveWriteUtils.getField(keyType, mapBlock, i);
                Object value = HiveWriteUtils.getField(valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        if (HiveUtil.isRowType(type)) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            List fieldTypes = type.getTypeParameters();
            HiveUtil.checkCondition(fieldTypes.size() == rowBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Expected row value field count does not match type field count", new Object[0]);
            ArrayList<Object> row = new ArrayList<Object>(rowBlock.getPositionCount());
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField((Type)fieldTypes.get(i), rowBlock, i);
                row.add(element);
            }
            return Collections.unmodifiableList(row);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    public static void checkTableIsWritable(Table table) {
        HiveWriteUtils.checkWritable(new SchemaTableName(table.getDbName(), table.getTableName()), Optional.empty(), MetaStoreUtils.getProtectMode((Table)table), table.getParameters(), table.getSd());
    }

    public static void checkPartitionIsWritable(String partitionName, Partition partition) {
        HiveWriteUtils.checkWritable(new SchemaTableName(partition.getDbName(), partition.getTableName()), Optional.of(partitionName), MetaStoreUtils.getProtectMode((Partition)partition), partition.getParameters(), partition.getSd());
    }

    private static void checkWritable(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters, StorageDescriptor storageDescriptor) {
        String tablePartitionDescription = "Table '" + tableName + "'";
        if (partitionName.isPresent()) {
            tablePartitionDescription = tablePartitionDescription + " partition '" + partitionName.get() + "'";
        }
        if (protectMode.offline) {
            throw new TableOfflineException(tableName, String.format("%s is offline", tablePartitionDescription));
        }
        String prestoOffline = parameters.get("presto_offline");
        if (!Strings.isNullOrEmpty((String)prestoOffline)) {
            throw new TableOfflineException(tableName, String.format("%s is offline for Presto: %s", tablePartitionDescription, prestoOffline));
        }
        if (protectMode.readOnly) {
            throw new HiveReadOnlyException(tableName, partitionName);
        }
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("%s does not contain a valid storage descriptor", tablePartitionDescription));
        }
        List bucketColumns = storageDescriptor.getBucketCols();
        if (bucketColumns != null && !bucketColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed Hive table has been temporarily disabled");
        }
        List sortColumns = storageDescriptor.getSortCols();
        if (sortColumns != null && !sortColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into bucketed sorted tables is not supported. %s", tablePartitionDescription));
        }
        SkewedInfo skewedInfo = storageDescriptor.getSkewedInfo();
        if (skewedInfo != null && skewedInfo.getSkewedColNames() != null && !skewedInfo.getSkewedColNames().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into bucketed tables with skew is not supported. %s", tablePartitionDescription));
        }
    }

    public static Path getTableDefaultLocation(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, String schemaName, String tableName) {
        String location = HiveWriteUtils.getDatabase(metastore, schemaName).getLocationUri();
        if (Strings.isNullOrEmpty((String)location)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not set", schemaName));
        }
        Path databasePath = new Path(location);
        if (!HiveWriteUtils.pathExists(hdfsEnvironment, databasePath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
        }
        if (!HiveWriteUtils.isDirectory(hdfsEnvironment, databasePath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
        }
        return new Path(databasePath, tableName);
    }

    private static Database getDatabase(HiveMetastore metastore, String database) {
        return metastore.getDatabase(database).orElseThrow(() -> new SchemaNotFoundException(database));
    }

    public static boolean pathExists(HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(path).exists(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    private static boolean isDirectory(HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(path).isDirectory(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static void renameDirectory(HdfsEnvironment hdfsEnvironment, String schemaName, String tableName, Path source, Path target) {
        if (HiveWriteUtils.pathExists(hdfsEnvironment, target)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to commit creation of table '%s.%s': target directory already exists: %s", schemaName, tableName, target));
        }
        if (!HiveWriteUtils.pathExists(hdfsEnvironment, target.getParent())) {
            HiveWriteUtils.createDirectory(hdfsEnvironment, target.getParent());
        }
        try {
            if (!hdfsEnvironment.getFileSystem(source).rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s: rename returned false", source, target));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    public static Path createTemporaryPath(HdfsEnvironment hdfsEnvironment, Path targetPath) {
        String temporaryPrefix = "/tmp/presto-" + StandardSystemProperty.USER_NAME.value();
        Path temporaryRoot = new Path(targetPath, temporaryPrefix);
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        HiveWriteUtils.createDirectory(hdfsEnvironment, temporaryPath);
        return temporaryPath;
    }

    public static void createDirectory(HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            if (!hdfsEnvironment.getFileSystem(path).mkdirs(path, ALL_PERMISSIONS)) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + path, (Throwable)e);
        }
        try {
            hdfsEnvironment.getFileSystem(path).setPermission(path, ALL_PERMISSIONS);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to set permission on directory: " + path, (Throwable)e);
        }
    }

    public static boolean isWritableType(HiveType hiveType) {
        return HiveWriteUtils.isWritableType(hiveType.getTypeInfo());
    }

    private static boolean isWritableType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                return HiveWriteUtils.isWritablePrimitiveType(primitiveCategory);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = Types.checkType(typeInfo, MapTypeInfo.class, "typeInfo");
                return HiveWriteUtils.isWritableType(mapTypeInfo.getMapKeyTypeInfo()) && HiveWriteUtils.isWritableType(mapTypeInfo.getMapValueTypeInfo());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = Types.checkType(typeInfo, ListTypeInfo.class, "typeInfo");
                return HiveWriteUtils.isWritableType(listTypeInfo.getListElementTypeInfo());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = Types.checkType(typeInfo, StructTypeInfo.class, "typeInfo");
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(HiveType::isSupportedType);
            }
        }
        return false;
    }

    private static boolean isWritablePrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIMESTAMP: 
            case BINARY: {
                return true;
            }
        }
        return false;
    }

    public static List<ObjectInspector> getRowColumnInspectors(List<Type> types) {
        return types.stream().map(HiveWriteUtils::getRowColumnInspector).collect(Collectors.toList());
    }

    public static ObjectInspector getRowColumnInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (HiveUtil.isArrayType(type) || HiveUtil.isMapType(type) || HiveUtil.isRowType(type)) {
            return HiveWriteUtils.getJavaObjectInspector(type);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static FieldSetter createFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanFieldSetter(rowInspector, row, field);
        }
        if (type.equals(BigintType.BIGINT)) {
            return new BigintFieldBuilder(rowInspector, row, field);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleFieldSetter(rowInspector, row, field);
        }
        if (type instanceof VarcharType) {
            return new VarcharFieldSetter(rowInspector, row, field);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new BinaryFieldSetter(rowInspector, row, field);
        }
        if (type.equals(DateType.DATE)) {
            return new DateFieldSetter(rowInspector, row, field);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new TimestampFieldSetter(rowInspector, row, field);
        }
        if (HiveUtil.isArrayType(type)) {
            return new ArrayFieldSetter(rowInspector, row, field, (Type)type.getTypeParameters().get(0));
        }
        if (HiveUtil.isMapType(type)) {
            return new MapFieldSetter(rowInspector, row, field, (Type)type.getTypeParameters().get(0), (Type)type.getTypeParameters().get(1));
        }
        if (HiveUtil.isRowType(type)) {
            return new RowFieldSetter(rowInspector, row, field, type.getTypeParameters());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static class RowFieldSetter
    extends FieldSetter {
        private final List<Type> fieldTypes;

        public RowFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, List<Type> fieldTypes) {
            super(rowInspector, row, field);
            this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        }

        @Override
        public void setField(Block block, int position) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> value = new ArrayList<Object>(this.fieldTypes.size());
            for (int i = 0; i < this.fieldTypes.size(); ++i) {
                Object element = HiveWriteUtils.getField(this.fieldTypes.get(i), rowBlock, i);
                value.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, value);
        }
    }

    private static class MapFieldSetter
    extends FieldSetter {
        private final Type keyType;
        private final Type valueType;

        public MapFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type keyType, Type valueType) {
            super(rowInspector, row, field);
            this.keyType = Objects.requireNonNull(keyType, "keyType is null");
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block mapBlock = (Block)block.getObject(position, Block.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = HiveWriteUtils.getField(this.keyType, mapBlock, i);
                Object value = HiveWriteUtils.getField(this.valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, map);
        }
    }

    private static class ArrayFieldSetter
    extends FieldSetter {
        private final Type elementType;

        public ArrayFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type elementType) {
            super(rowInspector, row, field);
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField(this.elementType, arrayBlock, i);
                list.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, list);
        }
    }

    private static class TimestampFieldSetter
    extends FieldSetter {
        private final TimestampWritable value = new TimestampWritable();

        public TimestampFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            long millisUtc = TimestampType.TIMESTAMP.getLong(block, position);
            this.value.setTime(millisUtc);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DateFieldSetter
    extends FieldSetter {
        private final DateWritable value = new DateWritable();

        public DateFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Ints.checkedCast((long)DateType.DATE.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BinaryFieldSetter
    extends FieldSetter {
        private final BytesWritable value = new BytesWritable();

        public BinaryFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            byte[] bytes = VarbinaryType.VARBINARY.getSlice(block, position).getBytes();
            this.value.set(bytes, 0, bytes.length);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class VarcharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();

        public VarcharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(VarcharType.VARCHAR.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DoubleFieldSetter
    extends FieldSetter {
        private final DoubleWritable value = new DoubleWritable();

        public DoubleFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(DoubleType.DOUBLE.getDouble(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BigintFieldBuilder
    extends FieldSetter {
        private final LongWritable value = new LongWritable();

        public BigintFieldBuilder(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BigintType.BIGINT.getLong(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BooleanFieldSetter
    extends FieldSetter {
        private final BooleanWritable value = new BooleanWritable();

        public BooleanFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BooleanType.BOOLEAN.getBoolean(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    public static abstract class FieldSetter {
        protected final SettableStructObjectInspector rowInspector;
        protected final Object row;
        protected final StructField field;

        protected FieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            this.rowInspector = Objects.requireNonNull(rowInspector, "rowInspector is null");
            this.row = Objects.requireNonNull(row, "row is null");
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public abstract void setField(Block var1, int var2);
    }
}

