/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetTimestampUtils;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.joda.time.DateTimeZone;
import parquet.column.Dictionary;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

public class ParquetHiveRecordCursor
extends HiveRecordCursor {
    private final ParquetRecordReader<FakeParquetRecord> recordReader;
    private final String[] names;
    private final com.facebook.presto.spi.type.Type[] types;
    private final boolean[] isPartitionColumn;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final boolean[] nullsRowDefault;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public ParquetHiveRecordCursor(Configuration configuration, Path path, long start, long length, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, boolean useParquetColumnNames, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate) {
        Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.totalBytes = length;
        int size = columns.size();
        this.names = new String[size];
        this.types = new com.facebook.presto.spi.type.Type[size];
        this.isPartitionColumn = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        this.nullsRowDefault = new boolean[size];
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            boolean isPartitionKey;
            HiveColumnHandle column = columns.get(columnIndex);
            String columnName = column.getName();
            com.facebook.presto.spi.type.Type type = typeManager.getType(column.getTypeSignature());
            this.names[columnIndex] = columnName;
            this.types[columnIndex] = type;
            this.isPartitionColumn[columnIndex] = isPartitionKey = column.isPartitionKey();
            boolean bl = this.nullsRowDefault[columnIndex] = !isPartitionKey;
            if (!isPartitionKey) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(columnName);
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{columnName});
            String partitionKeyValue = partitionKey.getValue();
            byte[] bytes = partitionKeyValue.getBytes(StandardCharsets.UTF_8);
            if (HiveUtil.isHiveNull(bytes)) {
                this.nullsRowDefault[columnIndex] = true;
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(partitionKeyValue, columnName);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(partitionKeyValue, columnName);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(partitionKeyValue, columnName);
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                this.longs[columnIndex] = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, columnName);
                continue;
            }
            if (type.equals(DateType.DATE)) {
                this.longs[columnIndex] = HiveUtil.datePartitionKey(partitionKey.getValue(), columnName);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), columnName));
        }
        this.recordReader = this.createParquetRecordReader(configuration, path, start, length, columns, useParquetColumnNames, typeManager, predicatePushdownEnabled, effectivePredicate);
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException newCompletedBytes) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public com.facebook.presto.spi.type.Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            System.arraycopy(this.nullsRowDefault, 0, this.nulls, 0, this.isPartitionColumn.length);
            if (this.closed || !this.recordReader.nextKeyValue()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        return this.booleans[fieldId];
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        return this.longs[fieldId];
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        return this.doubles[fieldId];
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        return this.slices[fieldId];
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Block.class);
        return this.objects[fieldId];
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        return this.nulls[fieldId];
    }

    private void validateType(int fieldId, Class<?> javaType) {
        if (this.types[fieldId].getJavaType() != javaType) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", javaType.getName(), this.types[fieldId].getJavaType().getName(), fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParquetRecordReader<FakeParquetRecord> createParquetRecordReader(Configuration configuration, Path path, long start, long length, List<HiveColumnHandle> columns, boolean useParquetColumnNames, TypeManager typeManager, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate) {
        try (HdfsParquetDataSource dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(path, configuration, start, length);){
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)path, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            List blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            PrestoReadSupport readSupport = new PrestoReadSupport(useParquetColumnNames, columns, fileSchema);
            List fields = columns.stream().filter(column -> !column.isPartitionKey()).map(column -> ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), fields);
            List<Object> splitGroup = new ArrayList<BlockMetaData>();
            for (BlockMetaData block2 : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block2.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                splitGroup.add(block2);
            }
            if (predicatePushdownEnabled) {
                ParquetPredicate parquetPredicate = ParquetPredicateUtils.buildParquetPredicate(columns, effectivePredicate, fileMetaData.getSchema(), typeManager);
                splitGroup = splitGroup.stream().filter(block -> ParquetPredicateUtils.predicateMatches(parquetPredicate, block, configuration, dataSource, requestedSchema, effectivePredicate)).collect(Collectors.toList());
            }
            long[] offsets = new long[splitGroup.size()];
            for (int i = 0; i < splitGroup.size(); ++i) {
                BlockMetaData block3 = (BlockMetaData)splitGroup.get(i);
                offsets[i] = block3.getStartingPos();
            }
            ParquetInputSplit split = new ParquetInputSplit(path, start, start + length, length, null, offsets);
            TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)configuration, (TaskAttemptID)new TaskAttemptID());
            PrestoParquetRecordReader realReader = new PrestoParquetRecordReader(readSupport);
            realReader.initialize((InputSplit)split, taskContext);
            PrestoParquetRecordReader prestoParquetRecordReader = realReader;
            return prestoParquetRecordReader;
        }
        catch (Exception e) {
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (!e.getClass().getSimpleName().equals("BlockMissingException")) throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
        }
    }

    private static BlockConverter createConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, Type parquetType, int fieldIndex) {
        if (parquetType.isPrimitive()) {
            return new ParquetPrimitiveConverter(prestoType, fieldIndex);
        }
        return ParquetHiveRecordCursor.createGroupConverter(prestoType, columnName, parquetType, fieldIndex);
    }

    private static GroupedConverter createGroupConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, Type parquetType, int fieldIndex) {
        GroupType groupType = parquetType.asGroupType();
        switch (prestoType.getTypeSignature().getBase()) {
            case "array": {
                return new ParquetListConverter(prestoType, columnName, groupType, fieldIndex);
            }
            case "map": {
                return new ParquetMapConverter(prestoType, columnName, groupType, fieldIndex);
            }
            case "row": {
                return new ParquetStructConverter(prestoType, columnName, groupType, fieldIndex);
            }
        }
        throw new IllegalArgumentException("Column " + columnName + " type " + parquetType.getOriginalType() + " not supported");
    }

    private static class ParquetPrimitiveConverter
    extends PrimitiveConverter
    implements BlockConverter {
        private final com.facebook.presto.spi.type.Type type;
        private final int fieldIndex;
        private BlockBuilder builder;

        public ParquetPrimitiveConverter(com.facebook.presto.spi.type.Type type, int fieldIndex) {
            this.type = type;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "parent builder is null");
        }

        @Override
        public void afterValue() {
        }

        private void addMissingValues() {
            while (this.builder.getPositionCount() < this.fieldIndex) {
                this.builder.appendNull();
            }
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            this.addMissingValues();
            BooleanType.BOOLEAN.writeBoolean(this.builder, value);
        }

        public void addDouble(double value) {
            this.addMissingValues();
            DoubleType.DOUBLE.writeDouble(this.builder, value);
        }

        public void addLong(long value) {
            this.addMissingValues();
            BigintType.BIGINT.writeLong(this.builder, value);
        }

        public void addBinary(Binary value) {
            this.addMissingValues();
            if (this.type == TimestampType.TIMESTAMP) {
                this.builder.writeLong(ParquetTimestampUtils.getTimestampMillis(value)).closeEntry();
            } else {
                VarbinaryType.VARBINARY.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value.getBytes()));
            }
        }

        public void addFloat(float value) {
            this.addMissingValues();
            DoubleType.DOUBLE.writeDouble(this.builder, (double)value);
        }

        public void addInt(int value) {
            this.addMissingValues();
            BigintType.BIGINT.writeLong(this.builder, (long)value);
        }
    }

    private static class ParquetMapEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter keyConverter;
        private final BlockConverter valueConverter;
        private BlockBuilder builder;

        public ParquetMapEntryConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType entryType) {
            GroupType entryGroupType;
            Preconditions.checkArgument((boolean)"map".equals(prestoType.getTypeSignature().getBase()));
            if (entryType.getOriginalType() != null) {
                Preconditions.checkArgument((entryType.getOriginalType() == OriginalType.MAP_KEY_VALUE ? 1 : 0) != 0, (String)"Expected MAP column '%s' field to be type %s, but is %s", (Object[])new Object[]{columnName, OriginalType.MAP_KEY_VALUE, entryType});
            }
            Preconditions.checkArgument(((entryGroupType = entryType.asGroupType()).getFieldCount() == 2 ? 1 : 0) != 0, (String)"Expected MAP column '%s' entry to have two fields, but has %s fields", (Object[])new Object[]{columnName, entryGroupType.getFieldCount()});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(0).equals("key"), (String)"Expected MAP column '%s' entry field 0 to be named 'key', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(0)});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(1).equals("value"), (String)"Expected MAP column '%s' entry field 1 to be named 'value', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(1)});
            Preconditions.checkArgument((boolean)entryGroupType.getType(0).isPrimitive(), (String)"Expected MAP column '%s' entry field 0 to be primitive, but is %s", (Object[])new Object[]{columnName, entryGroupType.getType(0)});
            this.keyConverter = ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName + ".key", (Type)entryGroupType.getFields().get(0), 0);
            this.valueConverter = ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(1), columnName + ".value", (Type)entryGroupType.getFields().get(1), 1);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.keyConverter;
            }
            if (fieldIndex == 1) {
                return (Converter)this.valueConverter;
            }
            throw new IllegalArgumentException("Map entry field must be 0 or 1 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.keyConverter.beforeValue(this.builder);
            this.valueConverter.beforeValue(this.builder);
        }

        public void end() {
            this.keyConverter.afterValue();
            this.valueConverter.afterValue();
            if (this.builder.getPositionCount() < 2) {
                this.builder.appendNull();
            }
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetMapConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type mapType;
        private final int fieldIndex;
        private final ParquetMapEntryConverter entryConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetMapConverter(com.facebook.presto.spi.type.Type type, String columnName, GroupType mapType, int fieldIndex) {
            Preconditions.checkArgument((mapType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected MAP column '%s' to only have one field, but has %s fields", (Object[])new Object[]{mapType.getName(), mapType.getFieldCount()});
            this.mapType = type;
            this.fieldIndex = fieldIndex;
            Type entryType = (Type)mapType.getFields().get(0);
            this.entryConverter = new ParquetMapEntryConverter(type, columnName + ".entry", entryType.asGroupType());
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.entryConverter;
            }
            throw new IllegalArgumentException("Map field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.mapType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.entryConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.entryConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetListEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter elementConverter;
        private BlockBuilder builder;

        public ParquetListEntryConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType elementType) {
            Preconditions.checkArgument((elementType.getOriginalType() == null ? 1 : 0) != 0, (String)"Expected LIST column '%s' field to be type STRUCT, but is %s", (Object[])new Object[]{columnName, elementType});
            Preconditions.checkArgument((elementType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' element to have one field, but has %s fields", (Object[])new Object[]{columnName, elementType.getFieldCount()});
            this.elementConverter = ParquetHiveRecordCursor.createConverter(prestoType, columnName + ".element", elementType.getType(0), 0);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST entry field must be 0 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.elementConverter.beforeValue(this.builder);
        }

        public void end() {
            this.elementConverter.afterValue();
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetListConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type arrayType;
        private final int fieldIndex;
        private final BlockConverter elementConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetListConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType listType, int fieldIndex) {
            Preconditions.checkArgument((listType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' to only have one field, but has %s fields", (Object[])new Object[]{columnName, listType.getFieldCount()});
            Preconditions.checkArgument((boolean)"array".equals(prestoType.getTypeSignature().getBase()));
            this.arrayType = prestoType;
            this.fieldIndex = fieldIndex;
            Type elementType = listType.getType(0);
            this.elementConverter = this.isElementType(elementType, listType.getName()) ? ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName + ".element", elementType, 0) : new ParquetListEntryConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName, elementType.asGroupType());
        }

        private boolean isElementType(Type repeatedType, String parentName) {
            if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1) {
                return true;
            }
            if (repeatedType.getName().equals("array")) {
                return true;
            }
            return repeatedType.getName().equals(parentName + "_tuple");
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.arrayType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.elementConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.elementConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetStructConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type rowType;
        private final int fieldIndex;
        private final List<BlockConverter> converters;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetStructConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType entryType, int fieldIndex) {
            Preconditions.checkArgument((boolean)"row".equals(prestoType.getTypeSignature().getBase()));
            List prestoTypeParameters = prestoType.getTypeParameters();
            List fieldTypes = entryType.getFields();
            Preconditions.checkArgument((prestoTypeParameters.size() == fieldTypes.size() ? 1 : 0) != 0, (String)"Schema mismatch, metastore schema for row column %s has %s fields but parquet schema has %s fields", (Object[])new Object[]{columnName, prestoTypeParameters.size(), fieldTypes.size()});
            this.rowType = prestoType;
            this.fieldIndex = fieldIndex;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (int i = 0; i < prestoTypeParameters.size(); ++i) {
                Type fieldType = (Type)fieldTypes.get(i);
                converters.add((Object)ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoTypeParameters.get(i), columnName + "." + fieldType.getName(), fieldType, i));
            }
            this.converters = converters.build();
        }

        public Converter getConverter(int fieldIndex) {
            return (Converter)this.converters.get(fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.rowType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            for (BlockConverter converter : this.converters) {
                converter.beforeValue(this.currentEntryBuilder);
            }
        }

        public void end() {
            for (BlockConverter converter : this.converters) {
                converter.afterValue();
            }
            while (this.currentEntryBuilder.getPositionCount() < this.converters.size()) {
                this.currentEntryBuilder.appendNull();
            }
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static abstract class GroupedConverter
    extends GroupConverter
    implements BlockConverter {
        private GroupedConverter() {
        }

        public abstract Block getBlock();
    }

    private static interface BlockConverter {
        public void beforeValue(BlockBuilder var1);

        public void afterValue();
    }

    public class ParquetColumnConverter
    extends GroupConverter {
        private final GroupedConverter groupedConverter;
        private final int fieldIndex;

        public ParquetColumnConverter(GroupedConverter groupedConverter, int fieldIndex) {
            this.groupedConverter = groupedConverter;
            this.fieldIndex = fieldIndex;
        }

        public Converter getConverter(int fieldIndex) {
            return this.groupedConverter.getConverter(fieldIndex);
        }

        public void start() {
            this.groupedConverter.beforeValue(null);
            this.groupedConverter.start();
        }

        public void end() {
            this.groupedConverter.afterValue();
            this.groupedConverter.end();
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).objects[this.fieldIndex] = this.groupedConverter.getBlock();
        }
    }

    private class ParquetPrimitiveColumnConverter
    extends PrimitiveConverter {
        private final int fieldIndex;

        private ParquetPrimitiveColumnConverter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).booleans[this.fieldIndex] = value;
        }

        public void addDouble(double value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addLong(long value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }

        public void addBinary(Binary value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            if (ParquetHiveRecordCursor.this.types[this.fieldIndex] == TimestampType.TIMESTAMP) {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = ParquetTimestampUtils.getTimestampMillis(value);
            } else {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = Slices.wrappedBuffer((byte[])value.getBytes());
            }
        }

        public void addFloat(float value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addInt(int value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }
    }

    public static class ParquetGroupConverter
    extends GroupConverter {
        private final List<Converter> converters;

        public ParquetGroupConverter(List<Converter> converters) {
            this.converters = converters;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters.get(fieldIndex);
        }

        public void start() {
        }

        public void end() {
        }
    }

    private static enum FakeParquetRecord {
        MATERIALIZE_RECORD;

    }

    private static class ParquetRecordConverter
    extends RecordMaterializer<FakeParquetRecord> {
        private final ParquetGroupConverter groupConverter;

        public ParquetRecordConverter(List<Converter> converters) {
            this.groupConverter = new ParquetGroupConverter(converters);
        }

        public FakeParquetRecord getCurrentRecord() {
            return FakeParquetRecord.MATERIALIZE_RECORD;
        }

        public GroupConverter getRootConverter() {
            return this.groupConverter;
        }
    }

    public final class PrestoReadSupport
    extends ReadSupport<FakeParquetRecord> {
        private final boolean useParquetColumnNames;
        private final List<HiveColumnHandle> columns;
        private final List<Converter> converters;

        public PrestoReadSupport(boolean useParquetColumnNames, List<HiveColumnHandle> columns, MessageType messageType) {
            this.columns = columns;
            this.useParquetColumnNames = useParquetColumnNames;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (int i = 0; i < columns.size(); ++i) {
                Type parquetType;
                HiveColumnHandle column = columns.get(i);
                if (column.isPartitionKey() || (parquetType = ParquetTypeUtils.getParquetType(column, messageType, useParquetColumnNames)) == null) continue;
                if (parquetType.isPrimitive()) {
                    converters.add((Object)new ParquetPrimitiveColumnConverter(i));
                    continue;
                }
                converters.add((Object)new ParquetColumnConverter(ParquetHiveRecordCursor.createGroupConverter(ParquetHiveRecordCursor.this.types[i], parquetType.getName(), parquetType, i), i));
            }
            this.converters = converters.build();
        }

        public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType messageType) {
            List fields = this.columns.stream().filter(column -> !column.isPartitionKey()).map(column -> ParquetTypeUtils.getParquetType(column, messageType, this.useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedProjection = new MessageType(messageType.getName(), fields);
            return new ReadSupport.ReadContext(requestedProjection);
        }

        public RecordMaterializer<FakeParquetRecord> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
            return new ParquetRecordConverter(this.converters);
        }
    }

    public class PrestoParquetRecordReader
    extends ParquetRecordReader<FakeParquetRecord> {
        public PrestoParquetRecordReader(PrestoReadSupport readSupport) {
            super((ReadSupport)readSupport);
        }
    }
}

