/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.ParquetValidationUtils;
import com.facebook.presto.hive.parquet.reader.ParquetBinaryColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetBooleanColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetDoubleColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetFloatColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetIntColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelNullReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelRLEReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelValuesReader;
import com.facebook.presto.hive.parquet.reader.ParquetLongColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetTimestampColumnReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.column.Encoding;
import parquet.column.ValuesType;
import parquet.column.page.DataPage;
import parquet.column.page.DataPageV1;
import parquet.column.page.DataPageV2;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageReader;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;

public abstract class ParquetColumnReader {
    protected final ColumnDescriptor columnDescriptor;
    protected ParquetLevelReader repetitionReader;
    protected ParquetLevelReader definitionReader;
    protected ValuesReader valuesReader;
    protected int nextBatchSize;
    private long totalValueCount;
    private PageReader pageReader;
    private Dictionary dictionary;
    private int repetitionLevel;
    private int definitionLevel;
    private int currentValueCount;
    private int pageValueCount;
    private DataPage page;
    private int remainingValueCountInPage;
    private int readOffset;

    public abstract BlockBuilder createBlockBuilder();

    public abstract void readValues(BlockBuilder var1, int var2);

    public abstract void skipValues(int var1);

    public static ParquetColumnReader createReader(ColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return new ParquetBooleanColumnReader(descriptor);
            }
            case INT32: {
                return new ParquetIntColumnReader(descriptor);
            }
            case INT64: {
                return new ParquetLongColumnReader(descriptor);
            }
            case INT96: {
                return new ParquetTimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new ParquetFloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new ParquetDoubleColumnReader(descriptor);
            }
            case BINARY: {
                return new ParquetBinaryColumnReader(descriptor);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    public ParquetColumnReader(ColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
    }

    public PageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(PageReader pageReader) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + this.columnDescriptor, (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.totalValueCount = pageReader.getTotalValueCount();
    }

    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    public int getCurrentRepetitionLevel() {
        return this.repetitionLevel;
    }

    public int getCurrentDefinitionLevel() {
        return this.definitionLevel;
    }

    public ColumnDescriptor getDescriptor() {
        return this.columnDescriptor;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public Block readBlock(Type type) throws IOException {
        int valueCount;
        int valueNumber;
        Preconditions.checkArgument(((long)this.currentValueCount <= this.totalValueCount ? 1 : 0) != 0, (Object)"Already read all values in column chunk");
        if (this.readOffset != 0) {
            int valuePosition;
            int offsetNumber;
            for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offsetNumber) {
                if (this.page == null) {
                    this.readNextPage();
                }
                offsetNumber = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
                this.skipValues(offsetNumber);
                this.updatePosition(offsetNumber);
            }
            Preconditions.checkArgument((valuePosition == this.readOffset ? 1 : 0) != 0, (Object)("valuePosition " + valuePosition + " not equals to readOffset " + this.readOffset));
        }
        BlockBuilder blockBuilder = this.createBlockBuilder();
        for (valueCount = 0; valueCount < this.nextBatchSize; valueCount += valueNumber) {
            if (this.page == null) {
                this.readNextPage();
            }
            valueNumber = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount);
            this.readValues(blockBuilder, valueNumber);
            this.updatePosition(valueNumber);
        }
        Preconditions.checkArgument((valueCount == this.nextBatchSize ? 1 : 0) != 0, (Object)("valueCount " + valueCount + " not equals to batchSize " + this.nextBatchSize));
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return blockBuilder.build();
    }

    private void readNextPage() throws IOException {
        this.page = this.pageReader.readPage();
        ParquetValidationUtils.validateParquet(this.page != null, "Not enough values to read in column chunk", new Object[0]);
        this.pageValueCount = this.page.getValueCount();
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof DataPageV1 ? this.readPageV1((DataPageV1)this.page) : this.readPageV2((DataPageV2)this.page);
    }

    private void updatePosition(int valueNumber) {
        if (valueNumber == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= valueNumber;
        this.currentValueCount += valueNumber;
    }

    private ValuesReader readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.columnDescriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.columnDescriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new ParquetLevelValuesReader(rlReader);
        this.definitionReader = new ParquetLevelValuesReader(dlReader);
        try {
            byte[] bytes = page.getBytes().toByteArray();
            rlReader.initFromPage(this.pageValueCount, bytes, 0);
            int offset = rlReader.getNextOffset();
            dlReader.initFromPage(this.pageValueCount, bytes, offset);
            offset = dlReader.getNextOffset();
            return this.initDataReader(page.getValueEncoding(), bytes, offset, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + this.columnDescriptor, (Throwable)e);
        }
    }

    private ValuesReader readPageV2(DataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            return this.initDataReader(page.getDataEncoding(), page.getData().toByteArray(), 0, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.columnDescriptor, (Throwable)e);
        }
    }

    private ParquetLevelReader buildLevelRLEReader(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new ParquetLevelNullReader();
            }
            return new ParquetLevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read levels in page for col " + this.columnDescriptor, (Throwable)e);
        }
    }

    private ValuesReader initDataReader(Encoding dataEncoding, byte[] bytes, int offset, int valueCount) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(this.pageValueCount, bytes, offset);
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + this.columnDescriptor, (Throwable)e);
        }
    }
}

