/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.AbstractIterator;
import io.airlift.stats.TimeStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.InputFormat;

public class HiveFileIterator
extends AbstractIterator<LocatedFileStatus> {
    private final FileSystem fileSystem;
    private final DirectoryLister directoryLister;
    private final NamenodeStats namenodeStats;
    private final Path path;
    private final String partitionName;
    private final InputFormat<?, ?> inputFormat;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final TupleDomain<HiveColumnHandle> effectivePredicate;
    private RemoteIterator<LocatedFileStatus> remoteIterator;

    public HiveFileIterator(Path path, FileSystem fileSystem, DirectoryLister directoryLister, NamenodeStats namenodeStats, String partitionName, InputFormat<?, ?> inputFormat, Properties schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate) {
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
    }

    protected LocatedFileStatus computeNext() {
        try {
            if (this.remoteIterator == null) {
                this.remoteIterator = this.getLocatedFileStatusRemoteIterator(this.path);
            }
            while (this.remoteIterator.hasNext()) {
                LocatedFileStatus status = this.getLocatedFileStatus(this.remoteIterator);
                String fileName = status.getPath().getName();
                if (fileName.startsWith("_") || fileName.startsWith(".")) continue;
                return status;
            }
            return (LocatedFileStatus)this.endOfData();
        }
        catch (FileNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Partition location does not exist: " + this.path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteIterator<LocatedFileStatus> getLocatedFileStatusRemoteIterator(Path path) throws IOException {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getListLocatedStatus().time();){
            RemoteIterator<LocatedFileStatus> remoteIterator = this.directoryLister.list(this.fileSystem, path);
            return remoteIterator;
        }
        catch (IOException | RuntimeException e) {
            this.namenodeStats.getListLocatedStatus().recordException(e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocatedFileStatus getLocatedFileStatus(RemoteIterator<LocatedFileStatus> iterator) throws IOException {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getRemoteIteratorNext().time();){
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)iterator.next();
            return locatedFileStatus;
        }
        catch (IOException | RuntimeException e) {
            this.namenodeStats.getRemoteIteratorNext().recordException(e);
            throw e;
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public DirectoryLister getDirectoryLister() {
        return this.directoryLister;
    }

    public NamenodeStats getNamenodeStats() {
        return this.namenodeStats;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.inputFormat;
    }

    public Properties getSchema() {
        return this.schema;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public TupleDomain<HiveColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }
}

