/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigurationProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;

public class ConfigBinder {
    private final Binder binder;

    public static ConfigBinder configBinder(Binder binder) {
        return new ConfigBinder(binder);
    }

    private ConfigBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
    }

    public <T> void bindConfig(Class<T> configClass) {
        Objects.requireNonNull(configClass, "configClass is null");
        this.bindConfig(Key.get(configClass), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, Annotation annotation) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, (Annotation)annotation), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, Class<? extends Annotation> annotation) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, annotation), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        this.bindConfig(Key.get(configClass), configClass, prefix);
    }

    public <T> void bindConfig(Class<T> configClass, Annotation annotation, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, (Annotation)annotation), configClass, prefix);
    }

    public <T> void bindConfig(Class<T> configClass, Class<? extends Annotation> annotation, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, annotation), configClass, prefix);
    }

    public <T> void bindConfig(Key<T> key, Class<T> configClass, String prefix) {
        this.binder.bind(key).toProvider(new ConfigurationProvider<T>(key, configClass, prefix));
        this.createConfigDefaultsBinder(key);
    }

    public <T> void bindConfigDefaults(Class<T> configClass, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass), configDefaults);
    }

    public <T> void bindConfigDefaults(Class<T> configClass, Annotation annotation, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass, (Annotation)annotation), configDefaults);
    }

    public <T> void bindConfigDefaults(Class<T> configClass, Class<? extends Annotation> annotation, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass, annotation), configDefaults);
    }

    public <T> void bindConfigDefaults(Key<T> key, ConfigDefaults<T> configDefaults) {
        this.createConfigDefaultsBinder(key).addBinding().toInstance(new ConfigDefaultsHolder<T>(key, configDefaults));
    }

    private <T> Multibinder<ConfigDefaultsHolder<T>> createConfigDefaultsBinder(Key<T> key) {
        Type type = new TypeToken<ConfigDefaultsHolder<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of((Type)key.getTypeLiteral().getType())).getType();
        TypeLiteral typeLiteral = TypeLiteral.get((Type)type);
        if (key.getAnnotationType() == null) {
            return Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)typeLiteral);
        }
        if (key.hasAttributes()) {
            return Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)typeLiteral, (Annotation)key.getAnnotation());
        }
        return Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)typeLiteral, (Class)key.getAnnotationType());
    }
}

