/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorMetadata;
import com.facebook.presto.raptor.RaptorMetadataFactory;
import com.facebook.presto.raptor.RaptorNodePartitioningProvider;
import com.facebook.presto.raptor.RaptorPageSinkProvider;
import com.facebook.presto.raptor.RaptorPageSourceProvider;
import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.RaptorSplitManager;
import com.facebook.presto.raptor.RaptorTableProperties;
import com.facebook.presto.raptor.RaptorTransactionHandle;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class RaptorConnector
implements Connector {
    private static final Logger log = Logger.get(RaptorConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final RaptorMetadataFactory metadataFactory;
    private final RaptorSplitManager splitManager;
    private final RaptorPageSourceProvider pageSourceProvider;
    private final RaptorPageSinkProvider pageSinkProvider;
    private final RaptorNodePartitioningProvider nodePartitioningProvider;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final Set<SystemTable> systemTables;
    private final ConcurrentMap<ConnectorTransactionHandle, RaptorMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, RaptorMetadata>();

    @Inject
    public RaptorConnector(LifeCycleManager lifeCycleManager, RaptorMetadataFactory metadataFactory, RaptorSplitManager splitManager, RaptorPageSourceProvider pageSourceProvider, RaptorPageSinkProvider pageSinkProvider, RaptorNodePartitioningProvider nodePartitioningProvider, RaptorSessionProperties sessionProperties, RaptorTableProperties tableProperties, Set<SystemTable> systemTables) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null").getSessionProperties();
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null").getTableProperties();
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        RaptorTransactionHandle transaction = new RaptorTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create());
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        metadata.rollback();
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        return metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

