/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorBucketFunction;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.util.PageBuffer;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class RaptorPageSink
implements ConnectorPageSink {
    private final long transactionId;
    private final StorageManager storageManager;
    private final JsonCodec<ShardInfo> shardInfoCodec;
    private final int sampleWeightField;
    private final PageSorter pageSorter;
    private final List<Long> columnIds;
    private final List<Type> columnTypes;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final int[] bucketFields;
    private final long maxBufferBytes;
    private final PageWriter pageWriter;

    public RaptorPageSink(PageSorter pageSorter, StorageManager storageManager, JsonCodec<ShardInfo> shardInfoCodec, long transactionId, List<Long> columnIds, List<Type> columnTypes, Optional<Long> sampleWeightColumnId, List<Long> sortColumnIds, List<SortOrder> sortOrders, OptionalInt bucketCount, List<Long> bucketColumnIds, DataSize maxBufferSize) {
        this.transactionId = transactionId;
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.columnIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnIds, "columnIds is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.shardInfoCodec = Objects.requireNonNull(shardInfoCodec, "shardInfoCodec is null");
        this.maxBufferBytes = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes();
        Objects.requireNonNull(sampleWeightColumnId, "sampleWeightColumnId is null");
        this.sampleWeightField = columnIds.indexOf(sampleWeightColumnId.orElse(-1L));
        this.sortFields = ImmutableList.copyOf((Collection)sortColumnIds.stream().map(columnIds::indexOf).collect(Collectors.toList()));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.bucketFields = bucketColumnIds.stream().mapToInt(columnIds::indexOf).toArray();
        this.pageWriter = bucketCount.isPresent() ? new BucketedPageWriter(bucketCount.getAsInt()) : new SimplePageWriter();
        for (int field : this.bucketFields) {
            if (columnTypes.get(field).equals(BigintType.BIGINT)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing is only supported for BIGINT columns");
        }
    }

    public CompletableFuture<?> appendPage(Page page, Block sampleWeightBlock) {
        if (page.getPositionCount() == 0) {
            return NOT_BLOCKED;
        }
        if (this.sampleWeightField >= 0) {
            page = this.createPageWithSampleWeightBlock(page, sampleWeightBlock);
        }
        this.pageWriter.appendPage(page);
        return NOT_BLOCKED;
    }

    public Collection<Slice> finish() {
        ArrayList<ShardInfo> shards = new ArrayList<ShardInfo>();
        for (PageBuffer pageBuffer : this.pageWriter.getPageBuffers()) {
            pageBuffer.flush();
            shards.addAll(pageBuffer.getStoragePageSink().commit());
        }
        ImmutableList.Builder fragments = ImmutableList.builder();
        for (ShardInfo shard : shards) {
            fragments.add((Object)Slices.wrappedBuffer((byte[])this.shardInfoCodec.toJsonBytes((Object)shard)));
        }
        return fragments.build();
    }

    public void abort() {
        RuntimeException error = new RuntimeException("Exception during rollback");
        for (PageBuffer pageBuffer : this.pageWriter.getPageBuffers()) {
            try {
                pageBuffer.getStoragePageSink().rollback();
            }
            catch (Throwable t) {
                error.addSuppressed(t);
            }
        }
        if (error.getSuppressed().length > 0) {
            throw error;
        }
    }

    private PageBuffer createPageBuffer(OptionalInt bucketNumber) {
        return new PageBuffer(this.maxBufferBytes, this.storageManager.createStoragePageSink(this.transactionId, bucketNumber, this.columnIds, this.columnTypes), this.columnTypes, this.sortFields, this.sortOrders, this.pageSorter);
    }

    private Page createPageWithSampleWeightBlock(Page page, Block sampleWeightBlock) {
        Preconditions.checkArgument((page.getPositionCount() == sampleWeightBlock.getPositionCount() ? 1 : 0) != 0, (Object)"position count of page and sampleWeightBlock must match");
        int outputChannelCount = page.getChannelCount() + 1;
        Block[] blocks = new Block[outputChannelCount];
        blocks[this.sampleWeightField] = sampleWeightBlock;
        int pageChannel = 0;
        for (int channel = 0; channel < outputChannelCount; ++channel) {
            if (channel == this.sampleWeightField) continue;
            blocks[channel] = page.getBlock(pageChannel);
            ++pageChannel;
        }
        return new Page(blocks);
    }

    private static class PageStore {
        private final PageBuffer pageBuffer;
        private final PageBuilder pageBuilder;

        public PageStore(PageBuffer pageBuffer, List<Type> columnTypes) {
            this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
            this.pageBuilder = new PageBuilder(columnTypes);
        }

        public long getUsedMemoryBytes() {
            return this.pageBuilder.getSizeInBytes() + this.pageBuffer.getUsedMemoryBytes();
        }

        public PageBuffer getPageBuffer() {
            return this.pageBuffer;
        }

        public void appendPosition(Page page, int position) {
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(channel);
                this.pageBuilder.getType(channel).appendTo(block, position, blockBuilder);
            }
            if (this.pageBuilder.isFull()) {
                this.flushToPageBuffer();
            }
        }

        public void flushToPageBuffer() {
            if (!this.pageBuilder.isEmpty()) {
                this.pageBuffer.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
        }
    }

    private class BucketedPageWriter
    implements PageWriter {
        private final BucketFunction bucketFunction;
        private final Int2ObjectMap<PageStore> pageStores = new Int2ObjectOpenHashMap();

        public BucketedPageWriter(int bucketCount) {
            this.bucketFunction = new RaptorBucketFunction(bucketCount);
        }

        @Override
        public void appendPage(Page page) {
            Block[] blocks = new Block[RaptorPageSink.this.bucketFields.length];
            for (int i = 0; i < RaptorPageSink.this.bucketFields.length; ++i) {
                blocks[i] = page.getBlock(RaptorPageSink.this.bucketFields[i]);
            }
            Page bucketArgs = new Page(page.getPositionCount(), blocks);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = this.bucketFunction.getBucket(bucketArgs, position);
                PageStore store = (PageStore)this.pageStores.get(bucket);
                if (store == null) {
                    PageBuffer buffer = RaptorPageSink.this.createPageBuffer(OptionalInt.of(bucket));
                    store = new PageStore(buffer, RaptorPageSink.this.columnTypes);
                    this.pageStores.put(bucket, (Object)store);
                }
                store.appendPosition(page, position);
            }
            this.flushIfNecessary();
        }

        @Override
        public List<PageBuffer> getPageBuffers() {
            ImmutableList.Builder list = ImmutableList.builder();
            for (PageStore store : this.pageStores.values()) {
                store.flushToPageBuffer();
                store.getPageBuffer().flush();
                list.add((Object)store.getPageBuffer());
            }
            return list.build();
        }

        private void flushIfNecessary() {
            long totalBytes = 0L;
            long maxBytes = 0L;
            PageBuffer maxBuffer = null;
            for (PageStore store : this.pageStores.values()) {
                long bytes = store.getUsedMemoryBytes();
                totalBytes += bytes;
                if (maxBuffer != null && bytes <= maxBytes) continue;
                maxBuffer = store.getPageBuffer();
                maxBytes = bytes;
            }
            if (totalBytes > RaptorPageSink.this.maxBufferBytes && maxBuffer != null) {
                maxBuffer.flush();
            }
        }
    }

    private class SimplePageWriter
    implements PageWriter {
        private final PageBuffer pageBuffer;

        private SimplePageWriter() {
            this.pageBuffer = RaptorPageSink.this.createPageBuffer(OptionalInt.empty());
        }

        @Override
        public void appendPage(Page page) {
            this.pageBuffer.add(page);
        }

        @Override
        public List<PageBuffer> getPageBuffers() {
            return ImmutableList.of((Object)this.pageBuffer);
        }
    }

    private static interface PageWriter {
        public void appendPage(Page var1);

        public List<PageBuffer> getPageBuffers();
    }
}

