/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;

public class RaptorSplit
implements ConnectorSplit {
    private final String connectorId;
    private final Set<UUID> shardUuids;
    private final OptionalInt bucketNumber;
    private final List<HostAddress> addresses;
    private final TupleDomain<RaptorColumnHandle> effectivePredicate;
    private final OptionalLong transactionId;

    @JsonCreator
    public RaptorSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="shardUuids") Set<UUID> shardUuids, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="effectivePredicate") TupleDomain<RaptorColumnHandle> effectivePredicate, @JsonProperty(value="transactionId") OptionalLong transactionId) {
        this(connectorId, shardUuids, bucketNumber, (List<HostAddress>)ImmutableList.of(), effectivePredicate, transactionId);
    }

    public RaptorSplit(String connectorId, UUID shardUuid, List<HostAddress> addresses, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId) {
        this(connectorId, (Set<UUID>)ImmutableSet.of((Object)shardUuid), OptionalInt.empty(), addresses, effectivePredicate, transactionId);
    }

    public RaptorSplit(String connectorId, Set<UUID> shardUuids, int bucketNumber, HostAddress address, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId) {
        this(connectorId, shardUuids, OptionalInt.of(bucketNumber), (List<HostAddress>)ImmutableList.of((Object)address), effectivePredicate, transactionId);
    }

    private RaptorSplit(String connectorId, Set<UUID> shardUuids, OptionalInt bucketNumber, List<HostAddress> addresses, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.shardUuids = ImmutableSet.copyOf((Collection)Objects.requireNonNull(shardUuids, "shardUuid is null"));
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public Set<UUID> getShardUuids() {
        return this.shardUuids;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public TupleDomain<RaptorColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    @JsonProperty
    public OptionalLong getTransactionId() {
        return this.transactionId;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuids", this.shardUuids).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).add("hosts", this.addresses).omitNullValues().toString();
    }
}

