/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.presto.raptor.backup.BackupConfig;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.storage.BackupStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class BackupManager {
    private final Optional<BackupStore> backupStore;
    private final ExecutorService executorService;
    private final AtomicInteger pendingBackups = new AtomicInteger();
    private final BackupStats stats = new BackupStats();

    @Inject
    public BackupManager(Optional<BackupStore> backupStore, BackupConfig config) {
        this(backupStore, config.getBackupThreads());
    }

    public BackupManager(Optional<BackupStore> backupStore, int backupThreads) {
        Preconditions.checkArgument((backupThreads > 0 ? 1 : 0) != 0, (Object)"backupThreads must be > 0");
        this.backupStore = Objects.requireNonNull(backupStore, "backupStore is null");
        this.executorService = Executors.newFixedThreadPool(backupThreads, Threads.daemonThreadsNamed((String)"background-shard-backup-%s"));
    }

    @PreDestroy
    public void shutdown() {
        this.executorService.shutdownNow();
    }

    public CompletableFuture<?> submit(UUID uuid, File source) {
        Objects.requireNonNull(uuid, "uuid is null");
        Objects.requireNonNull(source, "source is null");
        if (!this.backupStore.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingBackups.incrementAndGet();
        return CompletableFuture.runAsync(new BackgroundBackup(uuid, source)).whenComplete((none, throwable) -> this.pendingBackups.decrementAndGet());
    }

    @Managed
    public int getPendingBackupCount() {
        return this.pendingBackups.get();
    }

    @Managed
    @Flatten
    public BackupStats getStats() {
        return this.stats;
    }

    private class BackgroundBackup
    implements Runnable {
        private final UUID uuid;
        private final File source;
        private final long queuedTime = System.nanoTime();

        public BackgroundBackup(UUID uuid, File source) {
            this.uuid = Objects.requireNonNull(uuid, "uuid is null");
            this.source = Objects.requireNonNull(source, "source is null");
        }

        @Override
        public void run() {
            try {
                BackupManager.this.stats.addQueuedTime(Duration.nanosSince((long)this.queuedTime));
                long start = System.nanoTime();
                ((BackupStore)BackupManager.this.backupStore.get()).backupShard(this.uuid, this.source);
                BackupManager.this.stats.addCopyShardDataRate(new DataSize((double)this.source.length(), DataSize.Unit.BYTE), Duration.nanosSince((long)start));
                BackupManager.this.stats.incrementBackupSuccess();
            }
            catch (Throwable t) {
                BackupManager.this.stats.incrementBackupFailure();
                throw Throwables.propagate((Throwable)t);
            }
        }
    }
}

