/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.presto.raptor.backup.BackupOperationStats;
import com.facebook.presto.raptor.backup.BackupStore;
import java.io.File;
import java.util.Objects;
import java.util.UUID;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ManagedBackupStore
implements BackupStore {
    private final BackupStore store;
    private final BackupOperationStats backupShard = new BackupOperationStats();
    private final BackupOperationStats restoreShard = new BackupOperationStats();
    private final BackupOperationStats deleteShard = new BackupOperationStats();
    private final BackupOperationStats shardExists = new BackupOperationStats();

    public ManagedBackupStore(BackupStore store) {
        this.store = Objects.requireNonNull(store, "store is null");
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        this.backupShard.run(() -> this.store.backupShard(uuid, source));
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        this.restoreShard.run(() -> this.store.restoreShard(uuid, target));
    }

    @Override
    public void deleteShard(UUID uuid) {
        this.deleteShard.run(() -> this.store.deleteShard(uuid));
    }

    @Override
    public boolean shardExists(UUID uuid) {
        return this.shardExists.run(() -> this.store.shardExists(uuid));
    }

    @Managed
    @Nested
    public BackupOperationStats getBackupShard() {
        return this.backupShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getRestoreShard() {
        return this.restoreShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getDeleteShard() {
        return this.deleteShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getShardExists() {
        return this.shardExists;
    }
}

