/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.Distribution;
import com.facebook.presto.raptor.metadata.SchemaTableNameMapper;
import com.facebook.presto.raptor.metadata.Table;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.metadata.ViewResult;
import com.facebook.presto.spi.SchemaTableName;
import java.util.List;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface MetadataDao {
    @SqlQuery(value="SELECT t.table_id, t.distribution_id, d.bucket_count\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\nWHERE t.schema_name = :schemaName\n  AND t.table_name = :tableName")
    @Mapper(value=Table.TableMapper.class)
    public Table getTableInformation(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.ordinal_position, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.column_id = :columnId\nORDER BY c.ordinal_position\n")
    public TableColumn getTableColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.ordinal_position, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\nORDER BY c.ordinal_position")
    public List<TableColumn> getTableColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT schema_name, table_name\nFROM tables\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    @Mapper(value=SchemaTableNameMapper.class)
    public List<SchemaTableName> listTables(@Bind(value="schemaName") String var1);

    @SqlQuery(value="SELECT DISTINCT schema_name FROM tables")
    public List<String> listSchemaNames();

    @SqlQuery(value="SELECT t.schema_name, t.table_name, c.column_id, c.column_name, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name, ordinal_position")
    public List<TableColumn> listTableColumns(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name, c.column_id, c.column_name, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\nORDER BY c.ordinal_position")
    public List<TableColumn> listTableColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.ordinal_position, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.sort_ordinal_position IS NOT NULL\nORDER BY c.sort_ordinal_position")
    public List<TableColumn> listSortColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name, c.column_id, c.column_name, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.bucket_ordinal_position IS NOT NULL\nORDER BY c.bucket_ordinal_position")
    public List<TableColumn> listBucketColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    @Mapper(value=SchemaTableNameMapper.class)
    public List<SchemaTableName> listViews(@Bind(value="schemaName") String var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name\n")
    @Mapper(value=ViewResult.Mapper.class)
    public List<ViewResult> getViews(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlUpdate(value="INSERT INTO tables (schema_name, table_name, compaction_enabled, distribution_id)\nVALUES (:schemaName, :tableName, :compactionEnabled, :distributionId)")
    @GetGeneratedKeys
    public long insertTable(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2, @Bind(value="compactionEnabled") boolean var3, @Bind(value="distributionId") Long var4);

    @SqlUpdate(value="INSERT INTO columns (table_id, column_id, column_name, ordinal_position, data_type, sort_ordinal_position, bucket_ordinal_position)\nVALUES (:tableId, :columnId, :columnName, :ordinalPosition, :dataType, :sortOrdinalPosition, :bucketOrdinalPosition)")
    public void insertColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3, @Bind(value="columnName") String var5, @Bind(value="ordinalPosition") int var6, @Bind(value="dataType") String var7, @Bind(value="sortOrdinalPosition") Integer var8, @Bind(value="bucketOrdinalPosition") Integer var9);

    @SqlUpdate(value="UPDATE tables SET\n  schema_name = :newSchemaName\n, table_name = :newTableName\nWHERE table_id = :tableId")
    public void renameTable(@Bind(value="tableId") long var1, @Bind(value="newSchemaName") String var3, @Bind(value="newTableName") String var4);

    @SqlUpdate(value="UPDATE columns SET column_name = :target\nWHERE table_id = :tableId\n  AND column_id = :columnId")
    public void renameColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3, @Bind(value="target") String var5);

    @SqlUpdate(value="INSERT INTO views (schema_name, table_name, data)\nVALUES (:schemaName, :tableName, :data)")
    public void insertView(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2, @Bind(value="data") String var3);

    @SqlUpdate(value="DELETE FROM tables WHERE table_id = :tableId")
    public int dropTable(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM columns WHERE table_id = :tableId")
    public int dropColumns(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM views\nWHERE schema_name = :schemaName\n  AND table_name = :tableName")
    public int dropView(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT temporal_column_id\nFROM tables\nWHERE table_id = :tableId\n  AND temporal_column_id IS NOT NULL")
    public Long getTemporalColumnId(@Bind(value="tableId") long var1);

    @SqlUpdate(value="UPDATE tables SET\ntemporal_column_id = :columnId\nWHERE table_id = :tableId")
    public void updateTemporalColumnId(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3);

    @SqlQuery(value="SELECT compaction_enabled FROM tables WHERE table_id = :tableId")
    public boolean isCompactionEnabled(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT table_id FROM tables WHERE table_id = :tableId FOR UPDATE")
    public Long getLockedTableId(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_id = :distributionId")
    public Distribution getDistribution(@Bind(value="distributionId") long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_name = :distributionName")
    public Distribution getDistribution(@Bind(value="distributionName") String var1);

    @SqlUpdate(value="INSERT INTO distributions (distribution_name, column_types, bucket_count)\nVALUES (:distributionName, :columnTypes, :bucketCount)")
    @GetGeneratedKeys
    public long insertDistribution(@Bind(value="distributionName") String var1, @Bind(value="columnTypes") String var2, @Bind(value="bucketCount") int var3);
}

