/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.BucketNode;
import com.facebook.presto.raptor.metadata.RaptorNode;
import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.metadata.ShardNode;
import com.facebook.presto.raptor.util.UuidUtil;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterArgumentFactory;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapperFactory;

@RegisterArgumentFactory(value={UuidUtil.UuidArgumentFactory.class})
@RegisterMapperFactory(value={UuidUtil.UuidMapperFactory.class})
public interface ShardDao {
    public static final int CLEANABLE_SHARDS_BATCH_SIZE = 1000;

    @SqlUpdate(value="INSERT INTO nodes (node_identifier) VALUES (:nodeIdentifier)")
    @GetGeneratedKeys
    public int insertNode(@Bind(value="nodeIdentifier") String var1);

    @SqlUpdate(value="INSERT INTO shards (shard_uuid, table_id, bucket_number, create_time, row_count, compressed_size, uncompressed_size)\nVALUES (:shardUuid, :tableId, :bucketNumber, CURRENT_TIMESTAMP, :rowCount, :compressedSize, :uncompressedSize)")
    @GetGeneratedKeys
    public long insertShard(@Bind(value="shardUuid") UUID var1, @Bind(value="tableId") long var2, @Bind(value="bucketNumber") Integer var4, @Bind(value="rowCount") long var5, @Bind(value="compressedSize") long var7, @Bind(value="uncompressedSize") long var9);

    @SqlUpdate(value="INSERT INTO shard_nodes (shard_id, node_id)\nVALUES (:shardId, :nodeId)\n")
    public void insertShardNode(@Bind(value="shardId") long var1, @Bind(value="nodeId") int var3);

    @SqlUpdate(value="INSERT INTO shard_nodes (shard_id, node_id)\nVALUES ((SELECT shard_id FROM shards WHERE shard_uuid = :shardUuid), :nodeId)")
    public void insertShardNode(@Bind(value="shardUuid") UUID var1, @Bind(value="nodeId") int var2);

    @SqlUpdate(value="DELETE FROM shard_nodes\nWHERE shard_id = (SELECT shard_id FROM shards WHERE shard_uuid = :shardUuid)\n  AND node_id = :nodeId")
    public void deleteShardNode(@Bind(value="shardUuid") UUID var1, @Bind(value="nodeId") int var2);

    @SqlQuery(value="SELECT node_id FROM nodes WHERE node_identifier = :nodeIdentifier")
    public Integer getNodeId(@Bind(value="nodeIdentifier") String var1);

    @SqlQuery(value="SELECT node_identifier FROM nodes WHERE node_id = :nodeId")
    public String getNodeIdentifier(@Bind(value="nodeId") int var1);

    @SqlQuery(value="SELECT node_id, node_identifier FROM nodes")
    @Mapper(value=RaptorNode.Mapper.class)
    public List<RaptorNode> getNodes();

    @SqlQuery(value="SELECT shard_uuid FROM shards WHERE table_id = :tableId")
    public List<UUID> getShards(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT s.table_id, s.shard_id, s.shard_uuid, s.bucket_number, s.row_count, s.compressed_size, s.uncompressed_size\nFROM shards s\nJOIN shard_nodes sn ON (s.shard_id = sn.shard_id)\nJOIN nodes n ON (sn.node_id = n.node_id)\nWHERE n.node_identifier = :nodeIdentifier")
    @Mapper(value=ShardMetadata.Mapper.class)
    public Set<ShardMetadata> getNodeShards(@Bind(value="nodeIdentifier") String var1);

    @SqlQuery(value="SELECT s.shard_uuid, n.node_identifier\nFROM shards s\nJOIN shard_nodes sn ON (s.shard_id = sn.shard_id)\nJOIN nodes n ON (sn.node_id = n.node_id)\nWHERE s.table_id = :tableId")
    @Mapper(value=ShardNode.Mapper.class)
    public List<ShardNode> getShardNodes(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT node_identifier FROM nodes")
    @VisibleForTesting
    public Set<String> getAllNodesInUse();

    @SqlUpdate(value="DELETE FROM shard_nodes WHERE shard_id IN (\n  SELECT shard_id\n  FROM shards\n  WHERE table_id = :tableId)")
    public void dropShardNodes(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM shards WHERE table_id = :tableId")
    public void dropShards(@Bind(value="tableId") long var1);

    @SqlUpdate(value="INSERT INTO external_batches (external_batch_id, successful)\nVALUES (:externalBatchId, TRUE)")
    public void insertExternalBatch(@Bind(value="externalBatchId") String var1);

    @SqlQuery(value="SELECT count(*)\nFROM external_batches\nWHERE external_batch_id = :externalBatchId")
    public boolean externalBatchExists(@Bind(value="externalBatchId") String var1);

    @SqlUpdate(value="INSERT INTO transactions (start_time) VALUES (CURRENT_TIMESTAMP)")
    @GetGeneratedKeys
    public long insertTransaction();

    @SqlUpdate(value="UPDATE transactions SET\n  successful = :successful\n, end_time = CURRENT_TIMESTAMP\nWHERE transaction_id = :transactionId\n  AND successful IS NULL")
    public int finalizeTransaction(@Bind(value="transactionId") long var1, @Bind(value="successful") boolean var3);

    @SqlQuery(value="SELECT successful FROM transactions WHERE transaction_id = :transactionId")
    public Boolean transactionSuccessful(@Bind(value="transactionId") long var1);

    @SqlUpdate(value="UPDATE transactions SET\n  successful = FALSE\n, end_time = CURRENT_TIMESTAMP\nWHERE successful IS NULL\n  AND start_time < :maxStartTime")
    public void abortOldTransactions(@Bind(value="maxStartTime") Timestamp var1);

    @SqlUpdate(value="INSERT INTO created_shards (shard_uuid, transaction_id)\nVALUES (:shardUuid, :transactionId)")
    public void insertCreatedShard(@Bind(value="shardUuid") UUID var1, @Bind(value="transactionId") long var2);

    @SqlUpdate(value="DELETE FROM created_shards WHERE transaction_id = :transactionId")
    public void deleteCreatedShards(@Bind(value="transactionId") long var1);

    @SqlBatch(value="DELETE FROM created_shards WHERE shard_uuid = :shardUuid")
    public void deleteCreatedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    public void insertDeletedShards(Iterable<UUID> var1);

    @SqlUpdate(value="INSERT INTO deleted_shards (shard_uuid, delete_time)\nSELECT shard_uuid, CURRENT_TIMESTAMP\nFROM shards\nWHERE table_id = :tableId")
    public void insertDeletedShards(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT s.shard_uuid\nFROM created_shards s\nJOIN transactions t ON (s.transaction_id = t.transaction_id)\nWHERE NOT t.successful\nLIMIT 10000")
    public List<UUID> getOldCreatedShardsBatch();

    @SqlQuery(value="SELECT shard_uuid\nFROM deleted_shards\nWHERE delete_time < :maxDeleteTime\nLIMIT 1000")
    public Set<UUID> getCleanableShardsBatch(@Bind(value="maxDeleteTime") Timestamp var1);

    @SqlBatch(value="DELETE FROM deleted_shards WHERE shard_uuid = :shardUuid")
    public void deleteCleanedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    @SqlBatch(value="INSERT INTO buckets (distribution_id, bucket_number, node_id)\nVALUES (:distributionId, :bucketNumber, :nodeId)\n")
    public void insertBuckets(@Bind(value="distributionId") long var1, @Bind(value="bucketNumber") List<Integer> var3, @Bind(value="nodeId") List<Integer> var4);

    @SqlQuery(value="SELECT b.bucket_number, n.node_identifier\nFROM buckets b\nJOIN nodes n ON (b.node_id = n.node_id)\nWHERE b.distribution_id = :distributionId\nORDER BY b.bucket_number")
    @Mapper(value=BucketNode.Mapper.class)
    public List<BucketNode> getBucketNodes(@Bind(value="distributionId") long var1);

    @SqlUpdate(value="UPDATE buckets SET node_id = :nodeId\nWHERE distribution_id = :distributionId\n  AND bucket_number = :bucketNumber")
    public void updateBucketNode(@Bind(value="distributionId") long var1, @Bind(value="bucketNumber") int var3, @Bind(value="nodeId") int var4);
}

