/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.util.UuidUtil;
import com.google.common.base.MoreObjects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ShardNode {
    private final UUID shardUuid;
    private final String nodeIdentifier;

    public ShardNode(UUID shardUuid, String nodeIdentifier) {
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null");
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShardNode other = (ShardNode)obj;
        return Objects.equals(this.shardUuid, other.shardUuid) && Objects.equals(this.nodeIdentifier, other.nodeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.shardUuid, this.nodeIdentifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuid", (Object)this.shardUuid).add("nodeIdentifier", (Object)this.nodeIdentifier).toString();
    }

    public static class Mapper
    implements ResultSetMapper<ShardNode> {
        public ShardNode map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new ShardNode(UuidUtil.uuidFromBytes(r.getBytes("shard_uuid")), r.getString("node_identifier"));
        }
    }
}

