/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.orc.memory.AggregatedMemoryContext;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorConnectorId;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.backup.BackupManager;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.ColumnStats;
import com.facebook.presto.raptor.metadata.ShardDelta;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardRecorder;
import com.facebook.presto.raptor.storage.OrcFileRewriter;
import com.facebook.presto.raptor.storage.OrcFileWriter;
import com.facebook.presto.raptor.storage.OrcPageSource;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.raptor.storage.Row;
import com.facebook.presto.raptor.storage.ShardRecoveryManager;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.raptor.storage.ShardStats;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.StoragePageSink;
import com.facebook.presto.raptor.storage.StorageService;
import com.facebook.presto.raptor.util.CurrentNodeId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class OrcStorageManager
implements StorageManager {
    private static final long MAX_ROWS = 1000000000L;
    private final String nodeId;
    private final StorageService storageService;
    private final Optional<BackupStore> backupStore;
    private final JsonCodec<ShardDelta> shardDeltaCodec;
    private final ReaderAttributes defaultReaderAttributes;
    private final BackupManager backupManager;
    private final ShardRecoveryManager recoveryManager;
    private final ShardRecorder shardRecorder;
    private final Duration recoveryTimeout;
    private final long maxShardRows;
    private final DataSize maxShardSize;
    private final TypeManager typeManager;
    private final ExecutorService deletionExecutor;

    @Inject
    public OrcStorageManager(CurrentNodeId currentNodeId, StorageService storageService, Optional<BackupStore> backupStore, JsonCodec<ShardDelta> shardDeltaCodec, ReaderAttributes readerAttributes, StorageManagerConfig config, RaptorConnectorId connectorId, BackupManager backgroundBackupManager, ShardRecoveryManager recoveryManager, ShardRecorder shardRecorder, TypeManager typeManager) {
        this(currentNodeId.toString(), storageService, backupStore, shardDeltaCodec, readerAttributes, backgroundBackupManager, recoveryManager, shardRecorder, typeManager, connectorId.toString(), config.getDeletionThreads(), config.getShardRecoveryTimeout(), config.getMaxShardRows(), config.getMaxShardSize());
    }

    public OrcStorageManager(String nodeId, StorageService storageService, Optional<BackupStore> backupStore, JsonCodec<ShardDelta> shardDeltaCodec, ReaderAttributes readerAttributes, BackupManager backgroundBackupManager, ShardRecoveryManager recoveryManager, ShardRecorder shardRecorder, TypeManager typeManager, String connectorId, int deletionThreads, Duration shardRecoveryTimeout, long maxShardRows, DataSize maxShardSize) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        this.storageService = Objects.requireNonNull(storageService, "storageService is null");
        this.backupStore = Objects.requireNonNull(backupStore, "backupStore is null");
        this.shardDeltaCodec = Objects.requireNonNull(shardDeltaCodec, "shardDeltaCodec is null");
        this.defaultReaderAttributes = Objects.requireNonNull(readerAttributes, "readerAttributes is null");
        this.backupManager = Objects.requireNonNull(backgroundBackupManager, "backgroundBackupManager is null");
        this.recoveryManager = Objects.requireNonNull(recoveryManager, "recoveryManager is null");
        this.recoveryTimeout = Objects.requireNonNull(shardRecoveryTimeout, "shardRecoveryTimeout is null");
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.maxShardRows = Math.min(maxShardRows, 1000000000L);
        this.maxShardSize = Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        this.shardRecorder = Objects.requireNonNull(shardRecorder, "shardRecorder is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.deletionExecutor = Executors.newFixedThreadPool(deletionThreads, Threads.daemonThreadsNamed((String)("raptor-delete-" + connectorId + "-%s")));
    }

    @PreDestroy
    public void shutdown() {
        this.deletionExecutor.shutdownNow();
    }

    @Override
    public ConnectorPageSource getPageSource(UUID shardUuid, OptionalInt bucketNumber, List<Long> columnIds, List<Type> columnTypes, TupleDomain<RaptorColumnHandle> effectivePredicate, ReaderAttributes readerAttributes, OptionalLong transactionId) {
        OrcDataSource dataSource = this.openShard(shardUuid, readerAttributes);
        AggregatedMemoryContext systemMemoryUsage = new AggregatedMemoryContext();
        try {
            OrcReader reader = new OrcReader(dataSource, (MetadataReader)new OrcMetadataReader(), readerAttributes.getMaxMergeDistance(), readerAttributes.getMaxReadSize());
            Map<Long, Integer> indexMap = OrcStorageManager.columnIdIndex(reader.getColumnNames());
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnIndexes = ImmutableList.builder();
            for (int i = 0; i < columnIds.size(); ++i) {
                long columnId = columnIds.get(i);
                if (RaptorColumnHandle.isShardRowIdColumn(columnId)) {
                    columnIndexes.add((Object)-2);
                    continue;
                }
                if (RaptorColumnHandle.isShardUuidColumn(columnId)) {
                    columnIndexes.add((Object)-3);
                    continue;
                }
                Integer index = indexMap.get(columnId);
                if (index == null) {
                    columnIndexes.add((Object)-1);
                    continue;
                }
                columnIndexes.add((Object)index);
                includedColumns.put((Object)index, (Object)columnTypes.get(i));
            }
            OrcPredicate predicate = OrcStorageManager.getPredicate(effectivePredicate, indexMap);
            OrcRecordReader recordReader = reader.createRecordReader((Map)includedColumns.build(), predicate, DateTimeZone.UTC, (AbstractAggregatedMemoryContext)systemMemoryUsage);
            Optional<ShardRewriter> shardRewriter = Optional.empty();
            if (transactionId.isPresent()) {
                shardRewriter = Optional.of(this.createShardRewriter(transactionId.getAsLong(), bucketNumber, shardUuid));
            }
            return new OrcPageSource(shardRewriter, recordReader, dataSource, columnIds, columnTypes, (List<Integer>)columnIndexes.build(), shardUuid, systemMemoryUsage);
        }
        catch (IOException | RuntimeException e) {
            try {
                dataSource.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to create page source for shard " + shardUuid, (Throwable)e);
        }
    }

    @Override
    public StoragePageSink createStoragePageSink(long transactionId, OptionalInt bucketNumber, List<Long> columnIds, List<Type> columnTypes) {
        return new OrcStoragePageSink(transactionId, columnIds, columnTypes, bucketNumber);
    }

    private ShardRewriter createShardRewriter(long transactionId, OptionalInt bucketNumber, UUID shardUuid) {
        return rowsToDelete -> CompletableFuture.supplyAsync(() -> this.rewriteShard(transactionId, bucketNumber, shardUuid, rowsToDelete), this.deletionExecutor);
    }

    private void writeShard(UUID shardUuid) {
        if (this.backupStore.isPresent() && !this.backupExists(shardUuid)) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Backup does not exist after write");
        }
        File stagingFile = this.storageService.getStagingFile(shardUuid);
        File storageFile = this.storageService.getStorageFile(shardUuid);
        this.storageService.createParents(storageFile);
        try {
            Files.move(stagingFile.toPath(), storageFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to move shard file", (Throwable)e);
        }
    }

    @VisibleForTesting
    OrcDataSource openShard(UUID shardUuid, ReaderAttributes readerAttributes) {
        File file = this.storageService.getStorageFile(shardUuid).getAbsoluteFile();
        if (!file.exists() && this.backupExists(shardUuid)) {
            try {
                Future<?> future = this.recoveryManager.recoverShard(shardUuid);
                future.get(this.recoveryTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_RECOVERY_ERROR, "Error recovering shard " + shardUuid, e.getCause());
            }
            catch (TimeoutException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Shard is being recovered from backup. Please retry in a few minutes: " + shardUuid);
            }
        }
        try {
            return OrcStorageManager.fileOrcDataSource(readerAttributes, file);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to open shard file: " + file, (Throwable)e);
        }
    }

    private static FileOrcDataSource fileOrcDataSource(ReaderAttributes readerAttributes, File file) throws FileNotFoundException {
        return new FileOrcDataSource(file, readerAttributes.getMaxMergeDistance(), readerAttributes.getMaxReadSize(), readerAttributes.getStreamBufferSize());
    }

    private boolean backupExists(UUID shardUuid) {
        return this.backupStore.isPresent() && this.backupStore.get().shardExists(shardUuid);
    }

    private ShardInfo createShardInfo(UUID shardUuid, OptionalInt bucketNumber, File file, Set<String> nodes, long rowCount, long uncompressedSize) {
        return new ShardInfo(shardUuid, bucketNumber, nodes, this.computeShardStats(file), rowCount, file.length(), uncompressedSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ColumnStats> computeShardStats(File file) {
        try (FileOrcDataSource dataSource = OrcStorageManager.fileOrcDataSource(this.defaultReaderAttributes, file);){
            OrcReader reader = new OrcReader((OrcDataSource)dataSource, (MetadataReader)new OrcMetadataReader(), this.defaultReaderAttributes.getMaxMergeDistance(), this.defaultReaderAttributes.getMaxReadSize());
            ImmutableList.Builder list = ImmutableList.builder();
            for (ColumnInfo info : this.getColumnInfo(reader)) {
                ShardStats.computeColumnStats(reader, info.getColumnId(), info.getType()).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
            }
            ImmutableList immutableList = list.build();
            return immutableList;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to read file: " + file, (Throwable)e);
        }
    }

    @VisibleForTesting
    Collection<Slice> rewriteShard(long transactionId, OptionalInt bucketNumber, UUID shardUuid, BitSet rowsToDelete) {
        File output;
        if (rowsToDelete.isEmpty()) {
            return ImmutableList.of();
        }
        UUID newShardUuid = UUID.randomUUID();
        File input = this.storageService.getStorageFile(shardUuid);
        OrcFileRewriter.OrcFileInfo info = OrcStorageManager.rewriteFile(input, output = this.storageService.getStagingFile(newShardUuid), rowsToDelete);
        long rowCount = info.getRowCount();
        if (rowCount == 0L) {
            return this.shardDelta(shardUuid, Optional.empty());
        }
        this.shardRecorder.recordCreatedShard(transactionId, newShardUuid);
        MoreFutures.getFutureValue(this.backupManager.submit(newShardUuid, output));
        ImmutableSet nodes = ImmutableSet.of((Object)this.nodeId);
        long uncompressedSize = info.getUncompressedSize();
        ShardInfo shard = this.createShardInfo(newShardUuid, bucketNumber, output, (Set<String>)nodes, rowCount, uncompressedSize);
        this.writeShard(newShardUuid);
        return this.shardDelta(shardUuid, Optional.of(shard));
    }

    private Collection<Slice> shardDelta(UUID oldShardUuid, Optional<ShardInfo> shardInfo) {
        List newShards = (List)shardInfo.map(ImmutableList::of).orElse(ImmutableList.of());
        ShardDelta delta = new ShardDelta((List<UUID>)ImmutableList.of((Object)oldShardUuid), newShards);
        return ImmutableList.of((Object)Slices.wrappedBuffer((byte[])this.shardDeltaCodec.toJsonBytes((Object)delta)));
    }

    private static OrcFileRewriter.OrcFileInfo rewriteFile(File input, File output, BitSet rowsToDelete) {
        try {
            return OrcFileRewriter.rewrite(input, output, rowsToDelete);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to rewrite shard file: " + input, (Throwable)e);
        }
    }

    private List<ColumnInfo> getColumnInfo(OrcReader reader) {
        List names = reader.getColumnNames();
        Type rowType = this.getType(reader.getFooter().getTypes(), 0);
        if (names.size() != rowType.getTypeParameters().size()) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Column names and types do not match");
        }
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < names.size(); ++i) {
            list.add((Object)new ColumnInfo(Long.parseLong((String)names.get(i)), (Type)rowType.getTypeParameters().get(i)));
        }
        return list.build();
    }

    private Type getType(List<OrcType> types, int index) {
        OrcType type = types.get(index);
        switch (type.getOrcTypeKind()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case LIST: {
                TypeSignature elementType = this.getType(types, type.getFieldTypeIndex(0)).getTypeSignature();
                return this.typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType), (List)ImmutableList.of());
            }
            case MAP: {
                TypeSignature keyType = this.getType(types, type.getFieldTypeIndex(0)).getTypeSignature();
                TypeSignature valueType = this.getType(types, type.getFieldTypeIndex(1)).getTypeSignature();
                return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType, (Object)valueType), (List)ImmutableList.of());
            }
            case STRUCT: {
                ImmutableList.Builder fieldTypes = ImmutableList.builder();
                for (int i = 0; i < type.getFieldCount(); ++i) {
                    fieldTypes.add((Object)this.getType(types, type.getFieldTypeIndex(i)).getTypeSignature());
                }
                return this.typeManager.getParameterizedType("row", (List)fieldTypes.build(), (List)ImmutableList.copyOf((Collection)type.getFieldNames()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Unhandled ORC type: " + type);
    }

    private static OrcPredicate getPredicate(TupleDomain<RaptorColumnHandle> effectivePredicate, Map<Long, Integer> indexMap) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (RaptorColumnHandle column : ((Map)effectivePredicate.getDomains().get()).keySet()) {
            Integer index = indexMap.get(column.getColumnId());
            if (index == null) continue;
            columns.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, index.intValue(), column.getColumnType()));
        }
        return new TupleDomainOrcPredicate(effectivePredicate, (List)columns.build());
    }

    private static Map<Long, Integer> columnIdIndex(List<String> columnNames) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (int i = 0; i < columnNames.size(); ++i) {
            map.put((Object)Long.valueOf(columnNames.get(i)), (Object)i);
        }
        return map.build();
    }

    private class OrcStoragePageSink
    implements StoragePageSink {
        private final long transactionId;
        private final List<Long> columnIds;
        private final List<Type> columnTypes;
        private final OptionalInt bucketNumber;
        private final List<File> stagingFiles = new ArrayList<File>();
        private final List<ShardInfo> shards = new ArrayList<ShardInfo>();
        private final List<CompletableFuture<?>> futures = new ArrayList();
        private boolean committed;
        private OrcFileWriter writer;
        private UUID shardUuid;

        public OrcStoragePageSink(long transactionId, List<Long> columnIds, List<Type> columnTypes, OptionalInt bucketNumber) {
            this.transactionId = transactionId;
            this.columnIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnIds, "columnIds is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        }

        @Override
        public void appendPages(List<Page> pages) {
            this.createWriterIfNecessary();
            this.writer.appendPages(pages);
        }

        @Override
        public void appendPages(List<Page> inputPages, int[] pageIndexes, int[] positionIndexes) {
            this.createWriterIfNecessary();
            this.writer.appendPages(inputPages, pageIndexes, positionIndexes);
        }

        @Override
        public void appendRow(Row row) {
            this.createWriterIfNecessary();
            this.writer.appendRow(row);
        }

        @Override
        public boolean isFull() {
            if (this.writer == null) {
                return false;
            }
            return this.writer.getRowCount() >= OrcStorageManager.this.maxShardRows || this.writer.getUncompressedSize() >= OrcStorageManager.this.maxShardSize.toBytes();
        }

        @Override
        public void flush() {
            if (this.writer != null) {
                this.writer.close();
                OrcStorageManager.this.shardRecorder.recordCreatedShard(this.transactionId, this.shardUuid);
                File stagingFile = OrcStorageManager.this.storageService.getStagingFile(this.shardUuid);
                this.futures.add(OrcStorageManager.this.backupManager.submit(this.shardUuid, stagingFile));
                ImmutableSet nodes = ImmutableSet.of((Object)OrcStorageManager.this.nodeId);
                long rowCount = this.writer.getRowCount();
                long uncompressedSize = this.writer.getUncompressedSize();
                this.shards.add(OrcStorageManager.this.createShardInfo(this.shardUuid, this.bucketNumber, stagingFile, (Set)nodes, rowCount, uncompressedSize));
                this.writer = null;
                this.shardUuid = null;
            }
        }

        @Override
        public List<ShardInfo> commit() {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"already committed");
            this.committed = true;
            this.flush();
            this.futures.forEach(MoreFutures::getFutureValue);
            for (ShardInfo shard : this.shards) {
                OrcStorageManager.this.writeShard(shard.getShardUuid());
            }
            return ImmutableList.copyOf(this.shards);
        }

        @Override
        public void rollback() {
            try {
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
            }
            finally {
                for (File file : this.stagingFiles) {
                    file.delete();
                }
                this.futures.forEach(future -> future.cancel(true));
                OrcStorageManager.this.backupStore.ifPresent(backupStore -> {
                    for (ShardInfo shard : this.shards) {
                        backupStore.deleteShard(shard.getShardUuid());
                    }
                });
            }
        }

        private void createWriterIfNecessary() {
            if (this.writer == null) {
                this.shardUuid = UUID.randomUUID();
                File stagingFile = OrcStorageManager.this.storageService.getStagingFile(this.shardUuid);
                OrcStorageManager.this.storageService.createParents(stagingFile);
                this.stagingFiles.add(stagingFile);
                this.writer = new OrcFileWriter(this.columnIds, this.columnTypes, stagingFile);
            }
        }
    }
}

