/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import java.util.Objects;

public class ReaderAttributes {
    private final DataSize maxMergeDistance;
    private final DataSize maxReadSize;
    private final DataSize streamBufferSize;

    @Inject
    public ReaderAttributes(StorageManagerConfig config) {
        this(config.getOrcMaxMergeDistance(), config.getOrcMaxReadSize(), config.getOrcStreamBufferSize());
    }

    public ReaderAttributes(DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxReadSize = Objects.requireNonNull(maxReadSize, "maxReadSize is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxReadSize() {
        return this.maxReadSize;
    }

    public DataSize getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public static ReaderAttributes from(ConnectorSession session) {
        return new ReaderAttributes(RaptorSessionProperties.getReaderMaxMergeDistance(session), RaptorSessionProperties.getReaderMaxReadSize(session), RaptorSessionProperties.getReaderStreamBufferSize(session));
    }
}

