/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.storage.CompactionSet;
import com.facebook.presto.raptor.storage.CompactionSetCreator;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import io.airlift.units.DataSize;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TemporalCompactionSetCreator
implements CompactionSetCreator {
    private final long maxShardSizeBytes;
    private final Type type;
    private final long maxShardRows;

    public TemporalCompactionSetCreator(DataSize maxShardSize, long maxShardRows, Type type) {
        Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        Preconditions.checkArgument((type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP) ? 1 : 0) != 0, (Object)"type must be timestamp or date");
        this.maxShardSizeBytes = maxShardSize.toBytes();
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.maxShardRows = maxShardRows;
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public Set<CompactionSet> createCompactionSets(long tableId, Set<ShardMetadata> shardMetadata) {
        if (shardMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder compactionSets = ImmutableSet.builder();
        Collection<Collection<ShardMetadata>> shardSets = TemporalCompactionSetCreator.getShardsByDaysBuckets(shardMetadata, this.type);
        for (Collection<ShardMetadata> shardSet : shardSets) {
            List shards = shardSet.stream().filter(shard -> shard.getUncompressedSize() < this.maxShardSizeBytes).filter(shard -> shard.getRowCount() < this.maxShardRows).sorted(new ShardSorter()).collect(Collectors.toList());
            long consumedBytes = 0L;
            long consumedRows = 0L;
            ImmutableSet.Builder shardsToCompact = ImmutableSet.builder();
            for (ShardMetadata shard2 : shards) {
                if (consumedBytes + shard2.getUncompressedSize() > this.maxShardSizeBytes || consumedRows + shard2.getRowCount() > this.maxShardRows) {
                    compactionSets.add((Object)new CompactionSet(tableId, (Set<ShardMetadata>)shardsToCompact.build()));
                    shardsToCompact = ImmutableSet.builder();
                    consumedBytes = 0L;
                    consumedRows = 0L;
                }
                shardsToCompact.add((Object)shard2);
                consumedBytes += shard2.getUncompressedSize();
                consumedRows += shard2.getRowCount();
            }
            if (shardsToCompact.build().isEmpty()) continue;
            compactionSets.add((Object)new CompactionSet(tableId, (Set<ShardMetadata>)shardsToCompact.build()));
        }
        return compactionSets.build();
    }

    private static Collection<Collection<ShardMetadata>> getShardsByDaysBuckets(Set<ShardMetadata> shardMetadata, Type type) {
        ImmutableMultimap.Builder shardsByDays = ImmutableMultimap.builder();
        shardMetadata.stream().filter(shard -> shard.getRangeStart().isPresent() && shard.getRangeEnd().isPresent()).forEach(shard -> {
            long day = TemporalCompactionSetCreator.determineDay(shard.getRangeStart().getAsLong(), shard.getRangeEnd().getAsLong(), type);
            shardsByDays.put((Object)day, shard);
        });
        ImmutableCollection byDays = shardsByDays.build().asMap().values();
        ImmutableList.Builder sets = ImmutableList.builder();
        for (Collection shards : byDays) {
            sets.addAll((Iterable)Multimaps.index((Iterable)shards, ShardMetadata::getBucketNumber).asMap().values());
        }
        return sets.build();
    }

    private static long determineDay(long rangeStart, long rangeEnd, Type type) {
        long millisInEndDay;
        long endDay;
        if (type.equals(DateType.DATE)) {
            return rangeStart;
        }
        long startDay = Duration.ofMillis(rangeStart).toDays();
        if (startDay == (endDay = Duration.ofMillis(rangeEnd).toDays())) {
            return startDay;
        }
        if (endDay - startDay > 1L) {
            return startDay + 1L;
        }
        long millisInStartDay = Duration.ofDays(endDay).toMillis() - rangeStart;
        return millisInStartDay >= (millisInEndDay = rangeEnd - Duration.ofDays(endDay).toMillis()) ? startDay : endDay;
    }

    private static class ShardSorter
    implements Comparator<ShardMetadata> {
        private ShardSorter() {
        }

        @Override
        public int compare(ShardMetadata shard1, ShardMetadata shard2) {
            long shard1Hours = Duration.ofMillis(shard1.getRangeStart().getAsLong()).toHours();
            long shard2Hours = Duration.ofMillis(shard2.getRangeStart().getAsLong()).toHours();
            long shard1Range = shard1.getRangeEnd().getAsLong() - shard1.getRangeStart().getAsLong();
            long shard2Range = shard2.getRangeEnd().getAsLong() - shard2.getRangeStart().getAsLong();
            return ComparisonChain.start().compare(shard1Hours, shard2Hours).compare(shard1Range, shard2Range).result();
        }
    }
}

