/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;
import java.util.Objects;

public class ConditionalModule
implements ConfigurationAwareModule {
    private final Module module;
    private final String property;
    private final String expectedValue;
    private ConfigurationFactory configurationFactory;

    public static ConfigurationAwareModule installIfPropertyEquals(String property, String expectedValue, Module module) {
        return new ConditionalModule(module, property, expectedValue);
    }

    private ConditionalModule(Module module, String property, String expectedValue) {
        this.module = Objects.requireNonNull(module, "module is null");
        this.property = Objects.requireNonNull(property, "property is null");
        this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue is null");
    }

    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
        configurationFactory.consumeProperty(this.property);
        if (!this.shouldInstall()) {
            configurationFactory.registerConfigurationClasses(this.module);
        }
    }

    public void configure(Binder binder) {
        Preconditions.checkState((this.configurationFactory != null ? 1 : 0) != 0, (Object)"configurationFactory was not set");
        if (!this.configurationFactory.getProperties().containsKey(this.property)) {
            binder.addError("Required configuration property '%s' was not set", new Object[]{this.property});
        }
        if (this.shouldInstall()) {
            binder.install(this.module);
        }
    }

    private boolean shouldInstall() {
        return this.expectedValue.equalsIgnoreCase((String)this.configurationFactory.getProperties().get(this.property));
    }
}

