/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.presto.raptor.util.DatabaseUtil;
import java.util.Objects;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;

public class DaoSupplier<T> {
    private final Class<? extends T> type;
    private final T dao;

    public <X extends T> DaoSupplier(IDBI dbi, Class<X> type) {
        Objects.requireNonNull(dbi, "dbi is null");
        Objects.requireNonNull(type, "type is null");
        this.type = type;
        this.dao = DatabaseUtil.onDemandDao(dbi, type);
    }

    public T onDemand() {
        return this.dao;
    }

    public T attach(Handle handle) {
        return (T)handle.attach(this.type);
    }
}

