/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Throwables;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.exceptions.DBIException;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static <T> T onDemandDao(IDBI dbi, Class<T> daoType) {
        return (T)Reflection.newProxy(daoType, (proxy, method, args) -> {
            try (Handle handle = dbi.open();){
                Object dao = handle.attach(daoType);
                Object object = method.invoke(dao, args);
                return object;
            }
            catch (DBIException e) {
                throw DatabaseUtil.metadataError(e);
            }
            catch (InvocationTargetException e) {
                throw DatabaseUtil.metadataError(e.getCause());
            }
        });
    }

    public static <T> T runTransaction(IDBI dbi, TransactionCallback<T> callback) {
        try {
            return (T)dbi.inTransaction(callback);
        }
        catch (DBIException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw DatabaseUtil.metadataError(e);
        }
    }

    public static PrestoException metadataError(Throwable cause) {
        return new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_METADATA_ERROR, "Failed to perform metadata operation", cause);
    }

    public static void runIgnoringConstraintViolation(Runnable task) {
        try {
            task.run();
        }
        catch (RuntimeException e) {
            for (Throwable throwable : Throwables.getCausalChain((Throwable)e)) {
                String state;
                if (!(throwable instanceof SQLException) || !(state = ((SQLException)throwable).getSQLState()).startsWith("23")) continue;
                return;
            }
            throw e;
        }
    }

    public static OptionalInt getOptionalInt(ResultSet rs, String name) throws SQLException {
        int value = rs.getInt(name);
        return rs.wasNull() ? OptionalInt.empty() : OptionalInt.of(value);
    }

    public static OptionalLong getOptionalLong(ResultSet rs, String name) throws SQLException {
        long value = rs.getLong(name);
        return rs.wasNull() ? OptionalLong.empty() : OptionalLong.of(value);
    }

    public static void bindOptionalInt(PreparedStatement statement, int index, OptionalInt value) throws SQLException {
        if (value.isPresent()) {
            statement.setInt(index, value.getAsInt());
        } else {
            statement.setNull(index, 4);
        }
    }
}

