/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.presto.raptor.storage.StoragePageSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PageBuffer {
    private final long maxMemoryBytes;
    private final StoragePageSink storagePageSink;
    private final List<Type> columnTypes;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final PageSorter pageSorter;
    private final List<Page> pages = new ArrayList<Page>();
    private long usedMemoryBytes;
    private long rowCount;

    public PageBuffer(long maxMemoryBytes, StoragePageSink storagePageSink, List<Type> columnTypes, List<Integer> sortFields, List<SortOrder> sortOrders, PageSorter pageSorter) {
        Preconditions.checkArgument((maxMemoryBytes > 0L ? 1 : 0) != 0, (Object)"maxMemoryBytes must be positive");
        this.maxMemoryBytes = maxMemoryBytes;
        this.columnTypes = Objects.requireNonNull(columnTypes, "columnTypes is null");
        this.sortFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortFields, "sortFields is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.storagePageSink = Objects.requireNonNull(storagePageSink, "storagePageSink is null");
    }

    public StoragePageSink getStoragePageSink() {
        return this.storagePageSink;
    }

    public long getUsedMemoryBytes() {
        return this.usedMemoryBytes;
    }

    public void add(Page page) {
        this.flushIfNecessary(page.getPositionCount());
        this.pages.add(page);
        this.usedMemoryBytes += page.getSizeInBytes();
        this.rowCount += (long)page.getPositionCount();
    }

    public void flush() {
        if (this.pages.isEmpty()) {
            return;
        }
        if (this.sortFields.isEmpty()) {
            this.storagePageSink.appendPages(this.pages);
        } else {
            this.appendSorted();
        }
        this.storagePageSink.flush();
        this.pages.clear();
        this.rowCount = 0L;
        this.usedMemoryBytes = 0L;
    }

    private void appendSorted() {
        long[] addresses = this.pageSorter.sort(this.columnTypes, this.pages, this.sortFields, this.sortOrders, Ints.checkedCast((long)this.rowCount));
        int[] pageIndex = new int[addresses.length];
        int[] positionIndex = new int[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            pageIndex[i] = this.pageSorter.decodePageIndex(addresses[i]);
            positionIndex[i] = this.pageSorter.decodePositionIndex(addresses[i]);
        }
        this.storagePageSink.appendPages(this.pages, pageIndex, positionIndex);
    }

    private void flushIfNecessary(int rowsToAdd) {
        if (this.storagePageSink.isFull() || !this.canAddRows(rowsToAdd)) {
            this.flush();
        }
    }

    private boolean canAddRows(int rowsToAdd) {
        return this.usedMemoryBytes < this.maxMemoryBytes && this.rowCount + (long)rowsToAdd < Integer.MAX_VALUE;
    }
}

