/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.util.Progressable;

public final class SyncingFileSystem
extends RawLocalFileSystem {
    public SyncingFileSystem(Configuration configuration) throws IOException {
        this.initialize(this.getUri(), configuration);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(path) && !overwrite) {
            throw new IOException("file already exists: " + path);
        }
        Path parent = path.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream((OutputStream)new BufferedOutputStream(new LocalFileOutputStream(this.pathToFile(path)), bufferSize), this.statistics);
    }

    private static class LocalFileOutputStream
    extends OutputStream {
        private final FileOutputStream out;
        private boolean closed;

        private LocalFileOutputStream(File file) throws IOException {
            this.out = new FileOutputStream(file);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.flush();
            this.out.getFD().sync();
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }
}

