/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.BitFieldReader;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

abstract class LazyNumericDictionaryTreeReader
extends LazyTreeReader {
    protected long[] dictionaryValues;
    protected int dictionarySize;
    protected RunLengthIntegerReader reader;
    protected BitFieldReader inDictionary;

    LazyNumericDictionaryTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    protected abstract int getNumBytes();

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.dictionarySize = encodings.get(this.columnId).getDictionarySize();
        this.dictionaryValues = new long[this.dictionarySize];
        StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
        InStream in = streams.get(name);
        for (int i = 0; i < this.dictionarySize; ++i) {
            this.dictionaryValues[i] = SerializationUtils.readIntegerType(in, 4, true, in.useVInts());
        }
        in.close();
        name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
        this.reader = new RunLengthIntegerReader(streams.get(name), false, this.getNumBytes());
        InStream inDictionaryStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.IN_DICTIONARY));
        BitFieldReader bitFieldReader = this.inDictionary = inDictionaryStream == null ? null : new BitFieldReader(inDictionaryStream);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
        if (this.inDictionary != null) {
            this.inDictionary.seek(index);
        }
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        if (this.inDictionary != null) {
            updatedStartIndex = this.inDictionary.loadIndeces(rowIndexEntries, updatedStartIndex);
        }
        return this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skip(numNonNullValues);
        if (this.inDictionary != null) {
            this.inDictionary.skip(numNonNullValues);
        }
    }

    protected long readPrimitive() throws IOException {
        boolean isInDictionary;
        boolean bl = isInDictionary = this.inDictionary == null || this.inDictionary.next() == 1;
        if (isInDictionary) {
            return this.dictionaryValues[(int)this.reader.next()];
        }
        return this.reader.next();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.inDictionary != null) {
            this.inDictionary.close();
        }
        this.dictionaryValues = null;
    }
}

