/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Joiner;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.com.google.common.primitives.Longs;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HdfsBlocksMetadata {
    private final String blockPoolId;
    private final long[] blockIds;
    private final List<byte[]> volumeIds;
    private final List<Integer> volumeIndexes;

    public HdfsBlocksMetadata(String blockPoolId, long[] blockIds, List<byte[]> volumeIds, List<Integer> volumeIndexes) {
        Preconditions.checkArgument(blockIds.length == volumeIndexes.size(), "Argument lengths should match");
        this.blockPoolId = blockPoolId;
        this.blockIds = blockIds;
        this.volumeIds = volumeIds;
        this.volumeIndexes = volumeIndexes;
    }

    public long[] getBlockIds() {
        return this.blockIds;
    }

    public List<byte[]> getVolumeIds() {
        return this.volumeIds;
    }

    public List<Integer> getVolumeIndexes() {
        return this.volumeIndexes;
    }

    public String toString() {
        return "Metadata for " + this.blockIds.length + " blocks in " + this.blockPoolId + ": " + Joiner.on(",").join(Longs.asList(this.blockIds));
    }
}

