/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InconsistentFSStateException
extends IOException {
    private static final long serialVersionUID = 1L;

    public InconsistentFSStateException(File dir, String descr) {
        super("Directory " + InconsistentFSStateException.getFilePath(dir) + " is in an inconsistent state: " + descr);
    }

    public InconsistentFSStateException(File dir, String descr, Throwable ex) {
        this(dir, descr + "\n" + StringUtils.stringifyException(ex));
    }

    private static String getFilePath(File dir) {
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return dir.getPath();
        }
    }
}

